/*
 * Decompiled with CFR 0.152.
 */
package bk2010.util;

import bk2010.util.BootLog;
import bk2010.util.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public final class Trace {
    static FileOutputStream traceStream;
    static OutputStreamWriter traceWriter;
    static boolean disabled;

    static {
        disabled = false;
    }

    private Trace() {
    }

    public static void appendLine(String str) {
        if (disabled) {
            return;
        }
        if (traceStream == null) {
            String traceName = "cputrace.log";
            try {
                traceStream = new FileOutputStream(traceName);
                traceWriter = new OutputStreamWriter((OutputStream)traceStream, StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                BootLog.l("Cannot create trace file %s", traceName);
                disabled = true;
                return;
            }
        }
        try {
            traceWriter.write(str);
            traceWriter.write(10);
            traceWriter.flush();
        }
        catch (IOException e) {
            disabled = true;
            Log.error("Error writing CPU trace file!");
        }
    }
}

