/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences.storage;

import bk2010.Shutdownable;
import bk2010.preferences.storage.Setting;
import bk2010.util.BootLog;
import bk2010.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConfigFile
implements Shutdownable {
    File configFile;
    SortedMap<String, Setting> settings = Collections.synchronizedSortedMap(new TreeMap());

    public ConfigFile(File cf) {
        this.configFile = cf;
    }

    public boolean readFromDisk() {
        FileInputStream fi;
        try {
            fi = new FileInputStream(this.configFile);
        }
        catch (FileNotFoundException e) {
            BootLog.l("Configuration file " + this.configFile.getPath() + " does not exist");
            return false;
        }
        try {
            String str;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fi, StandardCharsets.ISO_8859_1));
            StringBuilder prefixComment = new StringBuilder();
            while ((str = br.readLine()) != null) {
                String setValue;
                String setName;
                if ((str = str.trim()).charAt(0) == '#') {
                    prefixComment.append(str);
                    prefixComment.append('\n');
                    continue;
                }
                int setEnd = str.indexOf(61);
                if (setEnd < 1 || (setName = str.substring(0, setEnd).trim()).isEmpty() || (setValue = str.substring(setEnd + 1).trim()).isEmpty()) continue;
                Setting setting = new Setting(setName, setValue, prefixComment.toString());
                prefixComment = new StringBuilder();
                this.settings.put(setName, setting);
            }
            br.close();
            fi.close();
        }
        catch (IOException e) {
            BootLog.l("Got an " + e.getMessage() + " while reading configuration file " + this.configFile.getPath());
            return false;
        }
        return true;
    }

    public boolean writeToDisk() {
        try {
            FileOutputStream fo = new FileOutputStream(this.configFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fo, StandardCharsets.ISO_8859_1));
            Collection<Setting> allSettings = this.settings.values();
            for (Setting setting : allSettings) {
                if (!setting.comments.isEmpty()) {
                    bw.write(setting.comments);
                }
                bw.write(String.valueOf(setting.name) + " = " + setting.value + "\n");
            }
            bw.close();
            fo.close();
        }
        catch (IOException e) {
            Log.error("Can't write to configuration file " + this.configFile.getPath());
            return false;
        }
        return true;
    }

    public void setSetting(Setting s) {
        this.settings.put(s.name, s);
    }

    public Setting getSetting(String name) {
        return (Setting)this.settings.get(name);
    }

    @Override
    public void shutdown() {
        this.writeToDisk();
    }
}

