/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.preferences.PathStrings;
import bk2010.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class FakeTape {
    static short readAddr;

    public static String extractFilename(QBusProxy machine, short address) {
        QBusReadDTO dto = new QBusReadDTO();
        StringBuilder name = new StringBuilder(21);
        int i = 0;
        while (i < 16) {
            if (!machine.readByte((short)(address + i), dto)) {
                return null;
            }
            int b = dto.getInt();
            if (b == 0) break;
            if ((b &= 0x7F) < 32 || b == 63 || b == 42 || b == 34 || b == 58 || b == 47 || b == 92 || b == 39 || b == 44 || b == 59) {
                b = 95;
            } else if (b >= 65 && b <= 90) {
                b += 32;
            }
            name.append((char)b);
            ++i;
        }
        return name.toString().trim();
    }

    public static short loadFile(QBusProxy machine, short addr, String fileNameBase) throws IOException {
        FileInputStream ff;
        try {
            ff = new FileInputStream(String.valueOf(PathStrings.binFilesPath) + fileNameBase + ".bin");
        }
        catch (FileNotFoundException e) {
            try {
                ff = new FileInputStream(String.valueOf(PathStrings.binFilesPath) + fileNameBase.toUpperCase() + ".BIN");
            }
            catch (FileNotFoundException ee) {
                ff = new FileInputStream(fileNameBase);
            }
        }
        short size = 0;
        if (addr == 0) {
            addr = (short)(ff.read() | ff.read() << 8);
        } else {
            ff.read();
            ff.read();
        }
        readAddr = addr;
        size = (short)(ff.read() | ff.read() << 8);
        int i = 0;
        while (i < (size & 0xFFFF)) {
            machine.writeByte((short)(addr + i), (byte)ff.read());
            ++i;
        }
        if (ff.read() != -1) {
            Log.warning("WARNING: file %s.bin is longer than it's header says; it may be corrupted", fileNameBase);
        }
        ff.close();
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fakeTape(QBusProxy machine, short[] regs, boolean is11M) {
        short params = is11M ? regs[0] : regs[1];
        QBusReadDTO dto = new QBusReadDTO();
        Log.verbose("\nTape access with parameter block at %06o\n", params & 0xFFFF);
        machine.writeByte((short)(is11M ? 42 : params + 1), (byte)4);
        if (!machine.readByte(params, dto)) {
            return;
        }
        int operation = dto.getInt();
        if (operation == (is11M ? 1 : 3)) {
            String fnameBase = FakeTape.extractFilename(machine, (short)(params + 6));
            if (!machine.readWord((short)(params + 2), dto, false)) {
                return;
            }
            short addr = dto.value;
            Log.verbose("Reading file %s at address %08o\n", String.valueOf(PathStrings.binFilesPath) + fnameBase, addr & 0xFFFF);
            try {
                short size = FakeTape.loadFile(machine, addr, fnameBase);
                if (is11M) {
                    machine.writeWord((short)(params + 24), readAddr);
                    machine.writeWord((short)(params + 26), size);
                } else {
                    machine.writeWord((short)(params + 22), readAddr);
                    machine.writeWord((short)(params + 24), size);
                    machine.writeWord(180, readAddr);
                    machine.writeWord(182, size);
                }
                boolean fill = false;
                int i = 0;
                while (true) {
                    if (i >= 16) {
                        machine.writeByte((short)(params + 1), (byte)0);
                    }
                    if (!machine.readByte((short)(params + 6 + i), dto)) {
                        return;
                    }
                    byte b = (byte)dto.value;
                    if (fill || b == 0) {
                        fill = true;
                        b = 32;
                    }
                    machine.writeByte((short)(params + (is11M ? 28 : 26) + i), b);
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                Log.warning("File %s is not found", String.valueOf(PathStrings.binFilesPath) + fnameBase + ".bin");
            }
            catch (IOException e) {
                Log.warning("Unexpected error while reading file %s", String.valueOf(PathStrings.binFilesPath) + fnameBase + ".bin");
            }
        } else if (operation == (is11M ? 0 : 2)) {
            if (!machine.readWord((short)(params + 2), dto, false)) {
                return;
            }
            short addr = dto.value;
            if (!machine.readWord((short)(params + 4), dto, false)) {
                return;
            }
            short size = dto.value;
            String fname = String.valueOf(PathStrings.binFilesPath) + FakeTape.extractFilename(machine, (short)(params + 6)) + ".bin";
            Log.verbose("\nSaving file %s from address %08o with length %08o\n", fname, addr, size);
            try {
                FileOutputStream ff = new FileOutputStream(fname);
                ff.write(addr & 0xFF);
                ff.write(addr >> 8 & 0xFF);
                ff.write(size & 0xFF);
                ff.write(size >> 8 & 0xFF);
                while (true) {
                    short s = size;
                    size = (short)(s - 1);
                    if (s <= 0) {
                        ff.close();
                        machine.writeByte((short)(params + 1), (byte)0);
                        break;
                    }
                    short s2 = addr;
                    addr = (short)(s2 + 1);
                    machine.readByte(s2, dto);
                    ff.write(dto.getInt());
                }
            }
            catch (FileNotFoundException e) {
                Log.error("Unable to open file %s for writing", fname);
            }
            catch (IOException e) {
                Log.error("Unexpected error while writing file %s", fname);
            }
        }
        machine.readWord(regs[6], dto, false);
        regs[7] = dto.value;
        regs[6] = (short)(regs[6] + 2);
    }

    public static int forceLoad(QBusProxy machine, String fname, boolean is11M) {
        Log.l("\nForced loading of binary file %s\n", fname);
        int addr = -1;
        try {
            FileInputStream ff;
            try {
                ff = new FileInputStream(fname);
            }
            catch (FileNotFoundException e) {
                if (fname.indexOf(File.separatorChar) < 0 && fname.indexOf(47) < 0) {
                    fname = String.valueOf(PathStrings.binFilesPath) + fname.toUpperCase() + ".BIN";
                    ff = new FileInputStream(fname);
                }
                throw e;
            }
            short size = 0;
            addr = (short)(ff.read() | ff.read() << 8);
            size = (short)(ff.read() | ff.read() << 8);
            int i = 0;
            while (i < (size & 0xFFFF)) {
                machine.writeByte((short)(addr + i), (byte)ff.read());
                ++i;
            }
            if (ff.read() != -1) {
                Log.warning("File %s is longer than it's header says; it may be corrupted", fname);
            }
            ff.close();
            if (!is11M) {
                machine.writeWord(180, (short)addr);
                machine.writeWord(182, size);
            }
        }
        catch (FileNotFoundException e) {
            Log.warning("File %s not found", fname);
        }
        catch (IOException e) {
            Log.error("Unexpected error while reading file %s ()", fname, e.getMessage());
            addr = -1;
        }
        return addr;
    }
}

