/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.smk;

import bk2010.Shutdownable;
import bk2010.hardware.smk.HDDPassport;
import bk2010.util.BootLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HDD
implements Shutdownable {
    public static final int SECTOR_LENGTH = 512;
    static final short NODATA = -8531;
    RandomAccessFile hddImage;
    long totalSectors;
    boolean readOnly = true;
    byte[] rwBuffer = new byte[512];
    long sector;
    int offset;
    int sectorsLeft;
    HDState state = HDState.DISABLED;
    HDDPassport passport;
    HDDPassport fakePassport = new HDDPassport(1, 1, 1, 1L);

    public HDD(File image) {
        if (image == null) {
            return;
        }
        String path = image.getAbsolutePath();
        if (!image.exists()) {
            BootLog.l("Error: Unable to find HDD image %s", path);
            return;
        }
        if (!image.canRead()) {
            BootLog.l("Error: Cannot read HDD image %s", path);
            return;
        }
        this.readOnly = !image.canWrite();
        try {
            this.hddImage = new RandomAccessFile(image, this.readOnly ? "r" : "rw");
            this.totalSectors = this.hddImage.length() / 512L - 1L;
        }
        catch (FileNotFoundException e) {
            BootLog.l("Error: Cannot open HDD image %s", path);
            return;
        }
        catch (IOException e) {
            BootLog.l("Error: unexpected error while opening HDD image %s", path);
            return;
        }
        this.state = HDState.IDLE;
    }

    public boolean enabled() {
        return this.state != HDState.DISABLED;
    }

    public long getSectorCount() {
        if (!this.enabled()) {
            return 0L;
        }
        return this.totalSectors;
    }

    public HDDPassport getPassport() {
        if (this.passport == null) {
            if (this.hddImage == null) {
                return this.fakePassport;
            }
            byte[] raw = new byte[512];
            try {
                this.hddImage.seek(0L);
                this.hddImage.read(raw);
            }
            catch (IOException e) {
                this.passport = this.fakePassport;
                return this.passport;
            }
            ByteBuffer bb = ByteBuffer.wrap(raw).order(ByteOrder.LITTLE_ENDIAN);
            char tracks = bb.getChar(2);
            char heads = bb.getChar(6);
            char sectors = bb.getChar(12);
            this.passport = new HDDPassport(tracks, heads, sectors, tracks * heads * sectors);
        }
        return this.passport;
    }

    public boolean getDataRequest() {
        return this.state == HDState.READING || this.state == HDState.WRITING;
    }

    public boolean startRead(long startSector, int sectorCount) {
        if (!this.enabled()) {
            return false;
        }
        this.state = HDState.IDLE;
        if (startSector >= this.totalSectors) {
            return false;
        }
        this.sector = startSector;
        try {
            this.hddImage.seek(startSector * 512L);
            this.hddImage.read(this.rwBuffer);
        }
        catch (IOException e) {
            return false;
        }
        this.sectorsLeft = sectorCount - 1;
        this.offset = 0;
        this.state = HDState.READING;
        return true;
    }

    public short readWord() {
        if (this.state != HDState.READING) {
            return -8531;
        }
        int acc = this.rwBuffer[this.offset++] & 0xFF;
        acc |= this.rwBuffer[this.offset++] << 8;
        if (this.offset >= 512) {
            this.offset = 0;
            if (this.sectorsLeft-- < 0 || ++this.sector >= this.totalSectors) {
                this.state = HDState.IDLE;
                return (short)acc;
            }
            try {
                this.hddImage.read(this.rwBuffer);
            }
            catch (IOException e) {
                this.state = HDState.IDLE;
                return (short)acc;
            }
        }
        return (short)acc;
    }

    public boolean startWrite(long startSector, int sectorCount) {
        if (!this.enabled()) {
            return false;
        }
        this.state = HDState.IDLE;
        if (startSector >= this.totalSectors) {
            return false;
        }
        this.sector = startSector;
        try {
            this.hddImage.seek(startSector * 512L);
        }
        catch (IOException e) {
            return false;
        }
        this.sectorsLeft = sectorCount;
        this.offset = 0;
        this.state = HDState.WRITING;
        return true;
    }

    public boolean writeWord(short data) {
        if (this.state != HDState.WRITING) {
            return false;
        }
        this.rwBuffer[this.offset++] = (byte)data;
        this.rwBuffer[this.offset++] = (byte)(data >> 8);
        if (this.offset >= 512) {
            try {
                this.hddImage.write(this.rwBuffer);
            }
            catch (IOException e) {
                this.state = HDState.IDLE;
                return false;
            }
            this.offset = 0;
            --this.sectorsLeft;
            ++this.sector;
            if (this.sectorsLeft == 0) {
                this.state = HDState.IDLE;
                return true;
            }
            if (this.sectorsLeft < 0 || this.sector >= this.totalSectors) {
                this.state = HDState.IDLE;
                return false;
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        if (this.enabled() && this.hddImage != null) {
            this.state = HDState.DISABLED;
            try {
                this.hddImage.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.hddImage = null;
        }
    }

    static enum HDState {
        DISABLED,
        IDLE,
        READING,
        WRITING;

    }
}

