/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.BKMemorySelector;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.QBusSlave;
import bk2010.io.FloppyDisk;

public class FDDController
implements QBusSlave {
    protected static int CON_SEL0 = 0;
    protected static int CON_SEL1 = 1;
    protected static int CON_SEL2 = 2;
    protected static int CON_SEL3 = 3;
    protected static int CON_PWR = 4;
    protected static int CON_HEAD = 5;
    protected static int CON_DIR = 6;
    protected static int CON_SEEK = 7;
    protected static int CON_RESYNC = 8;
    protected static int CON_WRMARKER = 9;
    FloppyDisk[] drives = new FloppyDisk[2];
    FloppyDisk drive;
    short controlReg;
    boolean seekingMarker = true;
    boolean diskEnabled = false;
    TimeSource timeSource;
    long lastCycles;
    boolean isReadable = true;
    boolean SMKMode = false;
    BKMemorySelector memSelector;

    @Override
    public int getBaseAddress() {
        return 65112;
    }

    @Override
    public int getNumWords() {
        return 2;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public int peekWord(int addr) {
        return 65535;
    }

    @Override
    public boolean readWord(int addr, QBusReadDTO result, boolean opcode) {
        this.catchUp();
        if (!this.isReadable) {
            return false;
        }
        result.value = 0;
        if ((addr &= 0xFFFFFFFE) == 65112) {
            if (this.diskEnabled) {
                int tmp = this.drive.getStatus(this.controlReg >> CON_HEAD & 1);
                if (this.seekingMarker) {
                    if (!this.drive.isMarker(this.controlReg >> CON_HEAD & 1)) {
                        tmp &= 0xFFFFFF7F;
                    } else {
                        this.seekingMarker = false;
                    }
                }
                result.value = (short)tmp;
            }
            return true;
        }
        if (addr == 65114) {
            if (this.diskEnabled) {
                result.value = (short)this.drive.getData(this.controlReg >> CON_HEAD & 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.controlReg = 0;
        this.seekingMarker = true;
        this.diskEnabled = false;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        if (addr == 65112) {
            return this.writeWord(65112, (short)(this.controlReg & 0xFF00 | data & 0xFF));
        }
        if (addr == 65113) {
            return this.writeWord(65112, (short)(this.controlReg & 0xFF | data & 0xFF00));
        }
        return this.writeWord(addr, data);
    }

    @Override
    public boolean writeWord(int addr, short data) {
        this.catchUp();
        if ((addr &= 0xFFFFFFFE) == 65112) {
            int changeMask = this.controlReg ^ data;
            if ((changeMask & 0x13) != 0) {
                if (this.diskEnabled) {
                    this.drive.flush();
                }
                switch (data & 0x13) {
                    case 17: {
                        this.drive = this.drives[0];
                        break;
                    }
                    case 18: {
                        this.drive = this.drives[1];
                        break;
                    }
                    default: {
                        this.drive = null;
                    }
                }
                boolean bl = this.diskEnabled = this.drive != null;
            }
            if (this.diskEnabled) {
                if ((changeMask & 0x80) != 0 && (data & 0x80) != 0) {
                    if ((data & 0x40) != 0) {
                        this.drive.stepPlus();
                    } else {
                        this.drive.stepMinus();
                    }
                }
                if ((changeMask & 1 << CON_WRMARKER) != 0) {
                    this.drive.setMarker((data & 1 << CON_WRMARKER) != 0);
                }
            }
            if ((data & 0x100) != 0) {
                this.seekingMarker = true;
            }
            if (this.memSelector != null && (this.SMKMode || (changeMask & 0xC) != 0 || (this.controlReg & 6) == 6)) {
                this.isReadable = this.memSelector.setMemoryModelByFDCBits(data);
            }
            this.controlReg = data;
        } else if (addr == 65114) {
            this.seekingMarker = false;
            if (this.diskEnabled) {
                this.drive.deferredWrite(this.controlReg >> CON_HEAD & 1, data);
            }
        } else {
            return false;
        }
        return true;
    }

    public void catchUp() {
        long cyclesPassed = this.timeSource.getCycles() - this.lastCycles;
        if (cyclesPassed > 0L) {
            if (this.drives[0] != null) {
                this.drives[0].cycles(cyclesPassed);
            }
            if (this.drives[1] != null) {
                this.drives[1].cycles(cyclesPassed);
            }
        }
        this.lastCycles += cyclesPassed;
    }

    public FDDController(FloppyDisk driveA, FloppyDisk driveB, TimeSource timeSource) {
        this.drives[0] = driveA;
        this.drives[1] = driveB;
        this.timeSource = timeSource;
        this.lastCycles = timeSource.getCycles();
    }

    public void setMemorySelector(BKMemorySelector memSel, boolean SMKMode) {
        this.memSelector = memSel;
        this.SMKMode = SMKMode;
    }
}

