/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.helpers;

import bk2010.gui.helpers.Tools;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class OctalInputField
extends JTextField {
    private static final long serialVersionUID = 4079850305851014312L;
    int maxChars;

    public OctalInputField(int size) {
        super(new OctalDocument(size), null, size);
        this.maxChars = size;
        this.setFont(Tools.monoFont);
    }

    @Override
    protected Document createDefaultModel() {
        return new OctalDocument(6);
    }

    public int getValue() {
        Document doc = this.getDocument();
        try {
            String str = doc.getText(0, doc.getLength());
            return Integer.parseUnsignedInt(str, 8);
        }
        catch (Exception e) {
            return 0;
        }
    }

    static class OctalDocument
    extends PlainDocument {
        private static final long serialVersionUID = -7172090116482807879L;
        int maxChars;

        public OctalDocument(int maxChars) {
            this.maxChars = maxChars;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            int limit = this.maxChars - this.getLength();
            if (limit <= 0) {
                return;
            }
            char[] src = str.toCharArray();
            StringBuilder sb = new StringBuilder();
            char[] cArray = src;
            int n = src.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= '0' && c <= '7') {
                    sb.append(c);
                }
                if (--limit <= 0) break;
                ++n2;
            }
            try {
                super.insertString(offs, sb.toString(), a);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

