/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dialogs;

import bk2010.gui.dialogs.ConfigurationDialog;
import bk2010.gui.dialogs.DiskMountPanel;
import bk2010.preferences.types.Disk;
import bk2010.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class DiskChangeDialog
extends ConfigurationDialog {
    Disk diskCfg;
    Disk editableCfg;

    public DiskChangeDialog(String diskName, Disk dc) {
        super("Change disk settings");
        this.setIconImage(ResourceManager.getEmulatorIcon());
        this.diskCfg = dc;
        this.editableCfg = dc.clone();
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DiskChangeDialog.this.diskCfg.equals(DiskChangeDialog.this.editableCfg)) {
                    DiskChangeDialog.this.diskCfg = DiskChangeDialog.this.editableCfg;
                }
                DiskChangeDialog.this.setVisible(false);
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskChangeDialog.this.setVisible(false);
            }
        };
        this.add((Component)new DiskMountPanel(diskName, this.editableCfg, true), "Center");
        Box okCancelPanel = Box.createHorizontalBox();
        okCancelPanel.add(Box.createHorizontalGlue());
        JButton jbOk = new JButton("OK");
        jbOk.addActionListener(okAction);
        okCancelPanel.add(jbOk);
        JButton jbCancel = new JButton("Cancel");
        jbCancel.addActionListener(cancelAction);
        okCancelPanel.add(jbCancel);
        okCancelPanel.add(Box.createHorizontalGlue());
        InputMap imap = okCancelPanel.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(10, 0), "OK");
        imap.put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        ActionMap amap = okCancelPanel.getActionMap();
        amap.put("OK", okAction);
        amap.put("Cancel", cancelAction);
        this.add((Component)okCancelPanel, "South");
        this.pack();
        this.center();
        jbOk.requestFocusInWindow();
    }

    public static Disk invoke(String diskName, Disk dc) {
        DiskChangeDialog dlg = new DiskChangeDialog(diskName, dc);
        dlg.setVisible(true);
        Disk ndc = dlg.diskCfg;
        dlg.dispose();
        return ndc;
    }

    public static void main(String[] args) {
        Disk dc = DiskChangeDialog.invoke("Test disk", new Disk("test.img", false));
        System.out.println(dc.imageFile.toString());
        System.exit(0);
    }
}

