/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.dialogs.BinOpenDialog;
import bk2010.gui.helpers.OctalInputField;
import bk2010.gui.helpers.Tools;
import bk2010.hardware.bus.QBusProxy;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MemoryControlsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7730771718858103802L;
    OctalInputField addrInput;
    AddressCallback addrCallback;
    QBusProxy memory;

    public MemoryControlsPanel(AddressCallback addrCallback, final QBusProxy memory) {
        this.memory = memory;
        this.addrCallback = addrCallback;
        ((FlowLayout)this.getLayout()).setAlignment(0);
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel("Address:");
        label.setFont(Tools.monoFont);
        box.add(label);
        this.addrInput = new OctalInputField(6);
        this.addrInput.addActionListener(this);
        box.add(this.addrInput);
        box.add(Box.createHorizontalGlue());
        JButton loadButton = new JButton("Load ...");
        loadButton.setFont(Tools.monoFont);
        box.add(loadButton);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new BinOpenDialog(memory).setVisible(true);
            }
        });
        this.add(box);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.transferFocusUpCycle();
        this.addrCallback.selectAddress(this.addrInput.getValue());
    }
}

