/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.debugger.ui15.DebugActionDispatcher;
import bk2010.gui.debugger.ui15.DisasmModel;
import bk2010.gui.helpers.Tools;
import bk2010.hardware.DBTrapSource;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class DisasmView
extends JComponent
implements Scrollable,
AddressCallback {
    private static final long serialVersionUID = -5391332494503602378L;
    static final int TOTAL_MEMWORDS = 32768;
    DisasmModel disasmModel;
    int preferredColumns;
    int preferredRows = 30;
    int preferredWidth;
    Dimension preferredSize;
    Dimension totalSize;
    int pad = 2;
    int fontHeight;
    int fontWidth;
    int rowHeight;
    int fontBaseline;
    int totalHeight;
    int markedRow = 3;
    int cursorRow = -1;
    private DBTrapSource trapSource;

    public DisasmView(DisasmModel disasmModel) {
        this.disasmModel = disasmModel;
        this.preferredColumns = disasmModel.getMaxWidth();
        this.setFont(Tools.monoFont);
        this.fontHeight = Tools.fontHeight;
        this.fontWidth = Tools.fontWidth;
        this.preferredWidth = this.fontWidth * this.preferredColumns + this.pad + this.pad;
        this.rowHeight = this.fontHeight + this.pad + this.pad;
        this.totalHeight = this.rowHeight * 32768;
        this.fontBaseline = Tools.fontBase;
        int prefHeight = this.rowHeight * this.preferredRows;
        this.preferredSize = new Dimension(this.preferredWidth, prefHeight);
        this.totalSize = new Dimension(this.preferredWidth, this.totalHeight);
        this.setMinimumSize(new Dimension(this.preferredWidth, this.rowHeight));
        this.setMaximumSize(this.totalSize);
        this.setPreferredSize(this.totalSize);
        DebugActionDispatcher.addAddressCallback(this);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                DisasmView.this.postSelectionEvent(e.getX(), e.getY());
            }
        });
    }

    void postSelectionEvent(int x, int y) {
        int line = Math.max(y / this.rowHeight, 0);
        if (line >= Short.MAX_VALUE) {
            return;
        }
        int addr = y / this.rowHeight * 2;
        int cpos = x / this.fontWidth;
        if (cpos == 0) {
            if (this.trapSource != null) {
                this.trapSource.trapToggle(addr);
            }
        } else {
            DebugActionDispatcher.selectAddress(addr);
        }
        this.repaint();
    }

    public void ensureVisible(int addr) {
        addr &= 0xFFFE;
        Container parent = this.getParent();
        if (!(parent instanceof JViewport)) {
            return;
        }
        this.scrollRectToVisible(new Rectangle(0, this.rowHeight * (addr >> 1), this.preferredWidth, this.rowHeight * this.preferredRows / 2));
    }

    public void setMarkedAddr(int addr) {
        this.markedRow = (addr & 0xFFFF) >> 1;
    }

    public void setCursorAddr(int addr) {
        this.cursorRow = (addr & 0xFFFF) >> 1;
    }

    @Override
    public void selectAddress(int address) {
        this.setCursorAddr(address);
        this.ensureVisible(address);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight * 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color oldColor = g2.getColor();
        Rectangle vis = this.getVisibleRect();
        int firstLine = Math.max(vis.y / this.rowHeight, 0);
        int lastLine = Math.min((vis.y + vis.height + this.rowHeight - 1) / this.rowHeight, Short.MAX_VALUE);
        if (lastLine < firstLine) {
            return;
        }
        int i = firstLine;
        while (i <= lastLine) {
            int trapType;
            int y = i * this.rowHeight + this.pad;
            int addr = i * 2;
            if (i == this.markedRow) {
                g2.setColor(Color.GREEN);
                g2.fillRect(0, y - this.pad, this.getWidth(), this.rowHeight);
                g2.setColor(oldColor);
            }
            if (i == this.cursorRow) {
                g2.setColor(Color.YELLOW);
                g2.drawRect(0, y - this.pad, this.getWidth(), this.rowHeight);
                g2.setColor(oldColor);
            }
            String disasm = this.disasmModel.getDisasm(addr);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.trapSource != null && (trapType = this.trapSource.trapType(addr)) != 0) {
                g2.setColor(Color.RED);
                g2.drawChars("\u2022".toCharArray(), 0, 1, 0, y + this.fontBaseline);
                g2.setColor(oldColor);
            }
            g2.drawString(disasm, this.fontWidth, y + this.fontBaseline);
            ++i;
        }
    }

    public void setTrapSource(DBTrapSource source) {
        this.trapSource = source;
    }
}

