/*
 * Decompiled with CFR 0.152.
 */
package bk2010.util;

import bk2010.ShutdownMonitor;
import bk2010.Shutdownable;
import bk2010.util.Log;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;

public class Profiler
implements Shutdownable {
    static final int MEM_RANGE_WORDS = 32768;
    protected boolean profileGathered = false;
    protected boolean isEnabled = false;
    long[] execCounts = new long[32768];
    long[] cycleCounts = new long[32768];
    String profileName = "profile.log";

    public Profiler() {
        ShutdownMonitor.add(this);
    }

    public Profiler setEnable(boolean enable) {
        this.isEnabled = enable;
        return this;
    }

    public void clear() {
        Arrays.fill(this.execCounts, 0L);
        Arrays.fill(this.cycleCounts, 0L);
    }

    public void record(int address, long cycles) {
        int word;
        if (!this.isEnabled) {
            return;
        }
        int n = word = (address >> 1) % 32768;
        this.execCounts[n] = this.execCounts[n] + 1L;
        int n2 = word;
        this.cycleCounts[n2] = this.cycleCounts[n2] + cycles;
        this.profileGathered = true;
    }

    public void dumpProfile(String fileName) {
        Log.l("Writing execution profile to %s\n", fileName);
        if (!this.profileGathered) {
            Log.l("... but there is no execution data. Attempt ignored.");
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter fw = new FileWriter(fileName);){
                fw.write("; Address      Count       Cycles\n");
                int i = 0;
                while (i < 32768) {
                    long execs = this.execCounts[i];
                    if (execs != 0L) {
                        long cycles = this.cycleCounts[i];
                        fw.write(String.format(Locale.ROOT, "%08o: %12d %12d\n", i * 2, execs, cycles));
                    }
                    ++i;
                }
                fw.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.l("Error writing execution profile to %s\n", fileName);
        }
    }

    @Override
    public void shutdown() {
        if (this.profileGathered) {
            this.dumpProfile(this.profileName);
        }
    }
}

