/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.sound.NoSoundException;
import bk2010.sound.WaveWriter;
import bk2010.util.BootLog;
import bk2010.util.Log;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class StreamOutput {
    public final int sampleRate;
    public final int bufferSamples;
    public final int bytesPerSample;
    private final AudioFormat af;
    private SourceDataLine line;
    protected WaveWriter waveOutFile;

    public StreamOutput(int sampleRate, int bufferSamples) throws NoSoundException {
        this.sampleRate = sampleRate;
        this.bufferSamples = bufferSamples;
        this.bytesPerSample = 2;
        this.af = new AudioFormat(sampleRate, 16, 1, true, false);
        try {
            this.line = AudioSystem.getSourceDataLine(this.af);
            this.line.open(this.af, bufferSamples * this.bytesPerSample);
            BootLog.l("Audio: Opened line with %d bytes buffer.\n", this.line.getBufferSize());
        }
        catch (LineUnavailableException e) {
            throw new NoSoundException();
        }
        this.line.start();
    }

    public StreamOutput() throws NoSoundException {
        this(48000, 4096);
    }

    public void setWaveWriter(WaveWriter wave) {
        this.waveOutFile = wave;
    }

    public void pushSamples(byte[] buf, int off, int len) {
        int avl = this.line.available();
        if (avl >= 32768) {
            Log.warning("Audio buffer underrun: %d\n", avl);
        }
        if (!this.line.isRunning()) {
            Log.verbose('$');
        }
        if (this.line.write(buf, off, len) != len) {
            Log.verbose('%');
        }
        if (this.waveOutFile != null) {
            this.waveOutFile.append(buf, off, len);
        }
    }

    public long timeNanos() {
        return this.line.getLongFramePosition() * 1000000000L / (long)this.sampleRate;
    }
}

