/*
 * Decompiled with CFR 0.152.
 */
package bk2010.recorder;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class FlicHeader {
    public final int width;
    public final int height;
    public final int aspectX;
    public final int aspectY;
    public final int frameTime;
    public int patchSize;
    public int patchFrames;
    public int patchOFrame1;
    public int patchOFrame2;

    public FlicHeader(int width, int height, int aspectX, int aspectY, int frameTime) {
        this.width = width;
        this.height = height;
        this.aspectX = aspectX;
        this.aspectY = aspectY;
        this.frameTime = frameTime;
    }

    public byte[] asBytes(boolean isClosed) {
        byte[] buf = new byte[FlicHeader.size()];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(this.patchSize);
        bb.putShort((short)-20718);
        bb.putShort((short)this.patchFrames);
        bb.putShort((short)this.width);
        bb.putShort((short)this.height);
        bb.putShort((short)8);
        bb.putShort((short)(isClosed ? 3 : 0));
        bb.putInt(this.frameTime > 0 ? this.frameTime : 20);
        bb.putShort((short)0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putShort((short)this.aspectX);
        bb.putShort((short)this.aspectY);
        bb.position(80);
        bb.putInt(FlicHeader.size());
        bb.putInt(this.patchOFrame2);
        return buf;
    }

    public static final int size() {
        return 128;
    }
}

