/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences;

import bk2010.preferences.AYModes;
import bk2010.preferences.CovoxModes;
import bk2010.preferences.InterpolationSelection;
import bk2010.preferences.MachineBase;
import bk2010.preferences.MonoColor;
import bk2010.preferences.WindowSizes;
import bk2010.preferences.storage.ConfigFile;
import bk2010.preferences.types.Choice;
import bk2010.preferences.types.Disk;
import bk2010.preferences.types.OnOff;
import bk2010.preferences.types.Tape;
import bk2010.util.BootLog;
import bk2010.util.Log;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;

public class MachineConfiguration
implements Serializable {
    private static final long serialVersionUID = 669313841258972864L;
    ConfigFile configFile = new ConfigFile(new File("config.ini"));
    public Choice machine = new Choice("Machine type", MachineBase.modes);
    public Choice AY = new Choice("AY-3-8910", AYModes.modes);
    public Choice Covox = new Choice("Covox", CovoxModes.modes);
    public OnOff filterSound = new OnOff("Filter", true);
    public OnOff noSound = new OnOff("No sound");
    public OnOff fakeTape = new OnOff("Tape<->.bin", true);
    public Disk diskA = new Disk("a.img", false);
    public Disk diskB = new Disk("b.img", false);
    public Disk diskIDE0 = new Disk("c.hdi", false);
    public Tape readTape = new Tape("in.wav", false);
    public Tape writeTape = new Tape("out.wav", true);
    public OnOff fullScreen = new OnOff("Fullscreen", true);
    public Choice windowSize = new Choice("Window Size", WindowSizes.modes);
    public Choice interpolation = new Choice("Smooth ...", InterpolationSelection.conditions);
    public Choice monoColor = new Choice("Monochrome", MonoColor.colors);
    public OnOff debugger = new OnOff("debugger");
    public OnOff mixFrames = new OnOff("Antiflicker");
    public boolean doLaunch = true;
    public boolean noHUD = true;
    public boolean doTrace = false;
    public short traceTrigger = 0;
    public String launchBin;
    public boolean doRecordVideo = false;
    public String videoName = "bk2010.flc";
    HashMap<String, OnOff> swOO = new HashMap(16);
    HashMap<String, Choice> swChoice = new HashMap(16);

    public MachineConfiguration() {
        this.Covox.select(0);
        this.windowSize.select(5);
        this.monoColor.select(0);
        this.swOO.put("filter", this.filterSound);
        this.swOO.put("silent", this.noSound);
        this.swOO.put("faketape", this.fakeTape);
        this.swOO.put("debug", this.debugger);
        this.swOO.put("mixframes", this.mixFrames);
        this.swChoice.put("ay", this.AY);
        this.swChoice.put("covox", this.Covox);
        this.swChoice.put("windowsize", this.windowSize);
        this.swChoice.put("interpolate", this.interpolation);
        this.swChoice.put("monocolor", this.monoColor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseCommandLine(String[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        int total = args.length;
        boolean skipConfigurationDialog = false;
        int i = 0;
        while (i < total) {
            block97: {
                OnOff oosw;
                String cname;
                block98: {
                    cname = args[i];
                    if (cname.charAt(0) == '-') break block98;
                    BootLog.l("Invalid command line argument: " + cname);
                    break block97;
                }
                switch (cname) {
                    case "-bk0010": 
                    case "-b10": 
                    case "-bk10": {
                        this.machine.select(0);
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-b10d": 
                    case "-bk0010d": 
                    case "-bk10d": {
                        this.machine.select(1);
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-bk10bd": 
                    case "-bk0010bd": 
                    case "-b10bd": {
                        this.machine.select(2);
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-bk0011": 
                    case "-b11": 
                    case "-b11m": 
                    case "-bk11": 
                    case "-bk0011m": 
                    case "-bk11m": {
                        this.machine.select(3);
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-drivea": 
                    case "-a": 
                    case "-da": 
                    case "-fda": 
                    case "-deva": 
                    case "-diska": {
                        if (++i < total) {
                            this.diskA = new Disk(args[i], false);
                        }
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-driveb": 
                    case "-b": 
                    case "-db": 
                    case "-fdb": 
                    case "-devb": 
                    case "-diskb": {
                        if (++i < total) {
                            this.diskB = new Disk(args[i], false);
                        }
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-readtape": 
                    case "-rt": 
                    case "-tapein": {
                        if (++i < total) {
                            this.readTape = new Tape(args[i], false);
                        }
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-writetape": 
                    case "-tapeout": 
                    case "-wt": {
                        if (++i < total) {
                            this.writeTape = new Tape(args[i], false);
                        }
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-flc": 
                    case "-fli": 
                    case "-flic": {
                        this.doRecordVideo = true;
                        break block97;
                    }
                    case "-trace": {
                        this.doTrace = true;
                        if (++i >= total) break;
                        String strAddr = args[i];
                        try {
                            this.traceTrigger = (short)Integer.parseUnsignedInt(strAddr, 8);
                        }
                        catch (NumberFormatException e) {
                            --i;
                        }
                        break;
                    }
                    case "-bin": {
                        if (++i < total) {
                            this.launchBin = args[i];
                        }
                        this.noHUD = true;
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-run": {
                        skipConfigurationDialog = true;
                        break block97;
                    }
                    case "-hud": {
                        this.noHUD = false;
                        break block97;
                    }
                    case "-log": {
                        Log.setLogFile(new File("bk2010.log"));
                        break block97;
                    }
                    case "-verbose": {
                        Log.enableConsole(true);
                        break block97;
                    }
                    case "-debug": {
                        this.debugger.setState(true);
                        Log.enableConsole(false);
                        break block97;
                    }
                    case "-af": 
                    case "-mixframes": 
                    case "-antiflicker": {
                        this.mixFrames.setState(true);
                        break block97;
                    }
                }
                String stripped = cname.substring(1).toLowerCase();
                boolean raise = true;
                if (stripped.startsWith("no")) {
                    raise = false;
                    stripped = stripped.substring(2);
                }
                if ((oosw = this.swOO.get(stripped)) != null) {
                    if (i + 1 < total) {
                        switch (args[i + 1].toLowerCase()) {
                            case "1": 
                            case "on": 
                            case "yes": 
                            case "true": {
                                ++i;
                                break;
                            }
                            case "0": 
                            case "no": 
                            case "off": 
                            case "false": {
                                ++i;
                                raise = !raise;
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    } else {
                        oosw.setState(raise);
                        skipConfigurationDialog = true;
                    }
                } else {
                    String choice;
                    Choice csw = this.swChoice.get(stripped);
                    if (csw != null && i < total && csw.select(choice = args[i + 1])) {
                        skipConfigurationDialog = true;
                        ++i;
                    }
                }
            }
            ++i;
        }
        if (skipConfigurationDialog) {
            this.doLaunch = true;
        }
        return skipConfigurationDialog;
    }

    public boolean saveToFile() {
        this.machine.saveTo(this.configFile, "general.");
        this.AY.saveTo(this.configFile, "sound.");
        this.Covox.saveTo(this.configFile, "sound.");
        this.filterSound.saveTo(this.configFile, "sound.");
        this.noSound.saveTo(this.configFile, "sound.");
        this.fakeTape.saveTo(this.configFile, "sound.");
        this.diskA.saveTo(this.configFile, "diskA.");
        this.diskB.saveTo(this.configFile, "diskB.");
        this.readTape.saveTo(this.configFile, "readTape.");
        this.writeTape.saveTo(this.configFile, "writeTape.");
        this.fullScreen.saveTo(this.configFile, "screen.");
        this.windowSize.saveTo(this.configFile, "screen.");
        this.interpolation.saveTo(this.configFile, "screen.");
        this.monoColor.saveTo(this.configFile, "screen.");
        this.mixFrames.saveTo(this.configFile, "screen.");
        this.debugger.saveTo(this.configFile, "general.");
        return this.configFile.writeToDisk();
    }

    public boolean readFromFile() {
        if (!this.configFile.readFromDisk()) {
            return false;
        }
        this.machine.readFrom(this.configFile, "general.");
        this.AY.readFrom(this.configFile, "sound.");
        this.Covox.readFrom(this.configFile, "sound.");
        this.filterSound.readFrom(this.configFile, "sound.");
        this.noSound.readFrom(this.configFile, "sound.");
        this.fakeTape.readFrom(this.configFile, "sound.");
        this.diskA.readFrom(this.configFile, "diskA.");
        this.diskB.readFrom(this.configFile, "diskB.");
        this.readTape.readFrom(this.configFile, "readTape.");
        this.writeTape.readFrom(this.configFile, "writeTape.");
        this.fullScreen.readFrom(this.configFile, "screen.");
        this.windowSize.readFrom(this.configFile, "screen.");
        this.interpolation.readFrom(this.configFile, "screen.");
        this.monoColor.readFrom(this.configFile, "screen.");
        this.mixFrames.readFrom(this.configFile, "screen.");
        this.debugger.readFrom(this.configFile, "general.");
        return true;
    }
}

