/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

public final class Joystick {
    public static final int JOY_UP = 1;
    public static final int JOY_DOWN = 4;
    public static final int JOY_LEFT = 8;
    public static final int JOY_RIGHT = 2;
    public static final int JOY_FIRE1 = 32;
    public static final int JOY_FIRE2 = 64;
    public static final int JOY_SELECT = 128;
    public static final int JOY_START = 16;
    int joyUpBits = 1;
    int joyDownBits = 4;
    int joyLeftBits = 8;
    int joyRightBits = 2;
    int joyFire1Bits = 32;
    int joyFire2Bits = 64;
    int joySelectBits = 128;
    int joyStartBits = 16;
    int joyCurrentBits;
    private int state = 0;

    public void setState(int newState) {
        this.state = newState;
        int bits = 0;
        if ((this.state & 1) != 0) {
            bits |= this.joyUpBits;
        }
        if ((this.state & 4) != 0) {
            bits |= this.joyDownBits;
        }
        if ((this.state & 8) != 0) {
            bits |= this.joyLeftBits;
        }
        if ((this.state & 2) != 0) {
            bits |= this.joyRightBits;
        }
        if ((this.state & 0x20) != 0) {
            bits |= this.joyFire1Bits;
        }
        if ((this.state & 0x40) != 0) {
            bits |= this.joyFire2Bits;
        }
        if ((this.state & 0x80) != 0) {
            bits |= this.joySelectBits;
        }
        if ((this.state & 0x10) != 0) {
            bits |= this.joyStartBits;
        }
        this.joyCurrentBits = bits;
    }

    public void definePortBitsForState(int joystickState, int portBits) {
        if ((joystickState & 1) != 0) {
            this.joyUpBits = portBits;
        }
        if ((joystickState & 4) != 0) {
            this.joyDownBits = portBits;
        }
        if ((joystickState & 8) != 0) {
            this.joyLeftBits = portBits;
        }
        if ((joystickState & 2) != 0) {
            this.joyRightBits = portBits;
        }
        if ((joystickState & 0x20) != 0) {
            this.joyFire1Bits = portBits;
        }
        if ((joystickState & 0x40) != 0) {
            this.joyFire2Bits = portBits;
        }
        if ((joystickState & 0x80) != 0) {
            this.joySelectBits = portBits;
        }
        if ((joystickState & 0x10) != 0) {
            this.joyStartBits = portBits;
        }
    }

    public short getIO() {
        return (short)this.joyCurrentBits;
    }
}

