/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.smk;

import bk2010.Shutdownable;
import bk2010.util.BootLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HDD
implements Shutdownable {
    public static final int SECTOR_LENGTH = 512;
    static final short NODATA = -8531;
    RandomAccessFile hddImage;
    long totalSectors;
    boolean readOnly = true;
    byte[] rwBuffer = new byte[512];
    long sector;
    int offset;
    int sectorsLeft;
    HDState state = HDState.DISABLED;

    public HDD(File image) {
        if (image == null) {
            return;
        }
        String path = image.getAbsolutePath();
        if (!image.exists()) {
            BootLog.l("Error: Unable to find HDD image %s", path);
            return;
        }
        if (!image.canRead()) {
            BootLog.l("Error: Cannot read HDD image %s", path);
            return;
        }
        this.readOnly = !image.canWrite();
        try {
            this.hddImage = new RandomAccessFile(image, this.readOnly ? "r" : "rw");
            this.totalSectors = this.hddImage.length() / 512L;
        }
        catch (FileNotFoundException e) {
            BootLog.l("Error: Cannot open HDD image %s", path);
            return;
        }
        catch (IOException e) {
            BootLog.l("Error: unexpected error while opening HDD image %s", path);
            return;
        }
        this.state = HDState.IDLE;
    }

    public boolean enabled() {
        return this.state != HDState.DISABLED;
    }

    public long getSectorCount() {
        if (!this.enabled()) {
            return 0L;
        }
        return this.totalSectors;
    }

    public boolean startRead(long startSector, int sectorCount) {
        if (!this.enabled()) {
            return false;
        }
        this.state = HDState.IDLE;
        if (startSector >= this.totalSectors) {
            return false;
        }
        this.sector = startSector;
        try {
            this.hddImage.seek(startSector * 512L);
            this.hddImage.read(this.rwBuffer);
        }
        catch (IOException e) {
            return false;
        }
        this.sectorsLeft = sectorCount - 1;
        this.offset = 0;
        this.state = HDState.READING;
        return true;
    }

    public short readWord() {
        if (this.state != HDState.READING) {
            return -1;
        }
        if (this.offset >= 512) {
            this.offset = 0;
            if (this.sectorsLeft-- < 0 || ++this.sector >= this.totalSectors) {
                this.state = HDState.IDLE;
                return -8531;
            }
            try {
                this.hddImage.read(this.rwBuffer);
            }
            catch (IOException e) {
                this.state = HDState.IDLE;
                return -8531;
            }
        }
        int acc = this.rwBuffer[this.offset++] & 0xFF;
        return (short)(acc |= this.rwBuffer[this.offset++] << 8);
    }

    public boolean startWrite(long startSector, int sectorCount) {
        if (!this.enabled()) {
            return false;
        }
        this.state = HDState.IDLE;
        if (startSector >= this.totalSectors) {
            return false;
        }
        this.sector = startSector;
        try {
            this.hddImage.seek(startSector * 512L);
        }
        catch (IOException e) {
            return false;
        }
        this.sectorsLeft = sectorCount;
        this.offset = 0;
        this.state = HDState.WRITING;
        return true;
    }

    public boolean writeWord(short data) {
        if (this.state != HDState.WRITING) {
            return false;
        }
        if (this.offset >= 512) {
            try {
                this.hddImage.write(this.rwBuffer);
            }
            catch (IOException e) {
                this.state = HDState.IDLE;
                return false;
            }
            this.offset = 0;
            if (--this.sectorsLeft <= 0 || ++this.sector >= this.totalSectors) {
                this.state = HDState.IDLE;
                return false;
            }
        }
        this.rwBuffer[this.offset++] = (byte)data;
        this.rwBuffer[this.offset++] = (byte)(data >> 8);
        return true;
    }

    @Override
    public void shutdown() {
        if (this.enabled() && this.hddImage != null) {
            this.state = HDState.DISABLED;
            try {
                this.hddImage.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.hddImage = null;
        }
    }

    static enum HDState {
        DISABLED,
        IDLE,
        READING,
        WRITING;

    }
}

