/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.QBusSlave;
import bk2010.hardware.smk.HDD;

public class HDDController
implements QBusSlave {
    public static final int IDE_CMD = 65504;
    public static final int IDE_RESET = 65507;
    public static final int IDE_DEV_HEAD = 65506;
    public static final int IDE_TRK_LOW = 65508;
    public static final int IDE_TRK_HIGH = 65510;
    public static final int IDE_SECTOR = 65512;
    public static final int IDE_COUNT = 65514;
    public static final int IDE_FEATURES = 65516;
    public static final int IDE_DATA = 65518;
    public static final int IDE_STATUS = 65504;
    public static final int IDE_STATUS2 = 65507;
    public static final int IDE_ERROR = 65516;
    public static final int STAT_ERR = 1;
    public static final int STAT_DRQ = 8;
    public static final int STAT_DF = 32;
    public static final int STAT_DRDY = 64;
    public static final int STAT_BSY = 128;
    public static final int ERR_ABRT = 4;
    int ideError = 1;
    int ideTrkHigh;
    int ideTrkLow;
    int ideDevHead;
    int ideSector;
    int ideCount;
    int ideFeatures;
    int ideStatus;
    boolean mounted = false;
    int cylinders = 0;
    int heads = 16;
    int sectors = 255;
    int firstDataSector = 1;
    HDD drive;

    public void mount(HDD newDrive) {
        if (newDrive == this.drive) {
            return;
        }
        if (this.drive != null) {
            this.drive.shutdown();
        }
        this.drive = newDrive;
        if (newDrive == null) {
            this.mounted = false;
            return;
        }
        this.mounted = true;
        this.firstDataSector = 1;
        this.sectors = 255;
        this.heads = 16;
        long totalSectors = newDrive.getSectorCount();
        if (totalSectors < (long)(this.firstDataSector + this.sectors)) {
            this.cylinders = 0;
            this.mounted = false;
            this.drive = null;
            return;
        }
        this.cylinders = (int)((totalSectors - (long)this.firstDataSector) / (long)(this.heads * this.sectors));
    }

    final int translateCHS(int cylinder, int head, int sector) {
        if (cylinder >= this.cylinders || head >= this.heads || sector > this.sectors) {
            return -1;
        }
        return (cylinder * this.heads + head) * this.sectors + sector;
    }

    final int translateLBA(int cylinder, int head, int sector) {
        return -1;
    }

    int sectorFromCHS() {
        int track = this.ideTrkLow & 0xFF | (this.ideTrkHigh & 0xFF) << 8;
        return this.translateCHS(track, this.ideDevHead, this.ideSector);
    }

    protected void execWriteData(short data) {
        if (this.drive != null) {
            this.drive.writeWord(data);
        }
    }

    protected short execReadData() {
        if (this.drive != null) {
            return this.drive.readWord();
        }
        return -1;
    }

    protected void execCommand(int command) {
        command &= 0xFF;
        if (this.drive == null || !this.drive.enabled()) {
            this.ideStatus = 65;
            this.ideError = 4;
            return;
        }
        switch (command) {
            case 229: {
                this.ideCount = 255;
                this.ideStatus = 64;
                break;
            }
            case 144: {
                this.ideError = 1;
                break;
            }
            case 236: {
                this.ideStatus = 64;
                this.drive.startRead(0L, 1);
                break;
            }
            case 227: {
                this.ideStatus = 64;
                break;
            }
            case 225: {
                this.ideStatus = 64;
                break;
            }
            case 145: {
                break;
            }
            case 0: {
                this.ideStatus = 65;
                this.ideError = 4;
                break;
            }
            case 196: {
                break;
            }
            case 32: 
            case 33: {
                this.ideStatus = 64;
                this.drive.startRead(this.sectorFromCHS(), this.ideCount);
                break;
            }
            case 64: 
            case 65: {
                break;
            }
            case 112: {
                break;
            }
            case 239: {
                break;
            }
            case 198: {
                break;
            }
            case 230: {
                break;
            }
            case 226: {
                break;
            }
            case 224: {
                break;
            }
            case 197: {
                break;
            }
            case 3120: 
            case 3121: {
                break;
            }
            default: {
                this.ideStatus = 65;
                this.ideError = 4;
            }
        }
    }

    @Override
    public int getBaseAddress() {
        return 65504;
    }

    @Override
    public int getNumWords() {
        return 8;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean readWord(int addr, QBusReadDTO result, boolean opcode) {
        int response = 0;
        switch (addr) {
            case 65504: {
                break;
            }
            case 65516: {
                response = this.ideError;
                break;
            }
            case 65506: {
                response = this.ideDevHead;
                break;
            }
            case 65510: {
                response = this.ideTrkHigh;
                break;
            }
            case 65508: {
                response = this.ideTrkLow;
                break;
            }
            case 65518: {
                response = this.execReadData();
                break;
            }
            case 65514: {
                response = this.ideCount;
                break;
            }
            case 65512: {
                response = this.ideSector;
            }
        }
        result.value = (short)(~response);
        return true;
    }

    @Override
    public boolean writeWord(int addr, short data) {
        int masked = ~data & 0xFFFF;
        switch (addr) {
            case 65504: {
                if ((this.ideDevHead & 1) != 0) break;
                this.execCommand(masked);
                break;
            }
            case 65507: {
                break;
            }
            case 65506: {
                this.ideDevHead = masked;
                break;
            }
            case 65510: {
                this.ideTrkHigh = masked;
                break;
            }
            case 65508: {
                this.ideTrkLow = masked;
                break;
            }
            case 65518: {
                this.execWriteData((short)masked);
                break;
            }
            case 65516: {
                this.ideFeatures = masked;
                break;
            }
            case 65514: {
                this.ideCount = masked;
                break;
            }
            case 65512: {
                this.ideSector = masked;
            }
        }
        return true;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        return this.writeWord(addr, data);
    }
}

