/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware;

import bk2010.HeartbeatListener;
import bk2010.hardware.BKMemorySelector;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusObserver;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.QBusSlave;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.bus.registers.Keyboard;
import bk2010.hardware.bus.registers.SystemRegs;
import bk2010.io.Joystick;
import bk2010.io.Mouse;
import bk2010.preferences.PathStrings;
import bk2010.sound.AY8910;
import bk2010.sound.SoundRenderer;
import bk2010.sound.WaveReader;
import bk2010.util.BootLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BaseBK001x
extends QBusProxy
implements BKMemorySelector {
    protected static final int LEN_ROMBASIC10_160 = 8064;
    protected static final int LEN_ROMFDD_160 = 4096;
    protected static final int WLEN_SMK512 = 262144;
    protected static final int WLEN_1K = 512;
    protected static final int WLEN_8K = 4096;
    protected static final int OF_RAMB10_120 = 16384;
    protected static final int OF_RAMB10_140 = 20480;
    protected static final int OF_ROMB10_100 = 65536;
    protected static final int OF_ROMBASIC10_120 = 69632;
    protected static final int OF_ROMBASIC10_140 = 73728;
    protected static final int OF_ROMBASIC10_160 = 77824;
    protected static final int OF_ROMB11M_140 = 81920;
    protected static final int OF_ROMB11M_120 = 86016;
    protected static final int OF_ROMBASIC11M_1_100 = 90112;
    protected static final int OF_ROMBASIC11M_0_100 = 94208;
    protected static final int OF_ROMEXT = 102400;
    protected static final int OF_SMK = 106496;
    protected static final int OF_MEMSIZE = 368640;
    protected short[] memory = new short[368640];
    protected static final int MMAP_PAGE_SCALE_BITS = 2;
    protected static final int MMAP_PAGE_ADDR_BITS = 11;
    protected static final int MMAP_PAGE_MASK = 2047;
    protected static final int MMAP_PAGES = 32;
    protected int[] mMap = new int[32];
    protected int mmapReadable;
    protected int mmapWriteable;
    protected int mmapSpecial;
    protected int page160length;
    protected short syswritereg = 0;
    protected short sysmmapreg = 0;
    protected short iowritereg = 0;
    protected short ioreadreg = 0;
    protected static final short MOUSE_RESET_BIT = 8;
    protected short scrollReg = 0;
    protected short paletteReg = (short)16384;
    protected static final int VM_1BIT = 0;
    protected static final int VM_GRAY = 1;
    protected static final int VM_RGB = 2;
    protected static final int VM_LAST = 2;
    protected int videoMode = 2;
    protected boolean forceGray = false;
    protected boolean is11M = false;
    protected boolean is11SMK = false;
    protected boolean disableSlot100 = false;
    protected int frameCounter = 0;
    protected List<QBusSlave> plugins = new ArrayList<QBusSlave>();
    protected List<QBusObserver> observers = new ArrayList<QBusObserver>();
    public final Keyboard keyboard = new Keyboard();
    public final Joystick joystick = new Joystick();
    public final Mouse mouse;
    public final CPUTimer timer = new CPUTimer();
    public final SystemRegs sregs = new SystemRegs();
    private SoundRenderer srend;
    private AY8910 synthA;
    private AY8910 synthB;
    private WaveReader tapeRdr;
    private int tapeDelay = 0;
    private long lastTape = 0L;
    private static final int TAPE_SPEED = 272;
    private boolean covoxEnabled;
    private boolean covoxSmart;
    private boolean covoxByte;
    private boolean ioLoopback;
    protected static final int[] pageMasks = new int[]{15, 240, 3840, 61440, 983040, 0xF00000, 0xF000000, -268435456};
    public static final int SMK_EN_MASK = 6;
    public static final int SMK_PAGE0_BIT = 10;
    public static final int SMK_PAGE1_BIT = 2;
    public static final int SMK_PAGE2_BIT = 3;
    public static final int SMK_PAGE3_BIT = 0;
    boolean smkCREnabled = false;
    short oldSMKCR = 0;
    boolean oldMouseReset = false;
    private static final byte BC_LGRAY = 7;
    private static final byte BC_DGRAY = 8;
    private static final byte BC_BLACK = 0;
    private static final byte BC_BLUE = 9;
    private static final byte BC_GREEN = 10;
    private static final byte BC_RED = 12;
    private static final byte BC_YELLOW = 14;
    private static final byte BC_MAGENTA = 13;
    private static final byte BC_CYAN = 11;
    private static final byte BC_WHITE = 15;
    private static final byte BC_MRED = 16;
    private static final byte BC_DRED = 17;
    private static final byte BC_YG = 18;
    private static final byte BC_LG = 19;
    private static final byte BC_VIOLET = 20;
    private static final byte BC_DARKVIOLET = 21;
    private static final byte[] monoColorMap;
    private static final byte[] fullColorMap;
    private static final int MPM_COUNT = 18;
    private static final int MPM_PPS = 8;
    private static final int MPM_PPS_BITS = 3;
    private static final int MPM_SIZE = 256;
    private static final byte[] modePaletteMaps;
    protected byte[] raster;
    protected static final int RS_WIDTH = 48;
    protected static final int RS_SIZE = 15360;
    protected static final int RS_ADDRSYNC = 13440;
    protected static final int RS_TOPBLANK = 40;
    protected static final int RS_LEFTBLANK = 12;
    TimeSource ts;
    int cpw;
    int cpl;
    int cpf;
    long lastCycles;
    long lastFullFrame;
    int lastBeamPos;
    int lastVidPos;
    int lastSubPos;
    int scrollPos;

    static {
        byte[] byArray = new byte[4];
        byArray[1] = 8;
        byArray[2] = 7;
        byArray[3] = 15;
        monoColorMap = byArray;
        byte[] byArray2 = new byte[64];
        byArray2[1] = 9;
        byArray2[2] = 10;
        byArray2[3] = 12;
        byArray2[5] = 14;
        byArray2[6] = 13;
        byArray2[7] = 12;
        byArray2[9] = 11;
        byArray2[10] = 9;
        byArray2[11] = 13;
        byArray2[13] = 10;
        byArray2[14] = 11;
        byArray2[15] = 14;
        byArray2[17] = 13;
        byArray2[18] = 11;
        byArray2[19] = 15;
        byArray2[21] = 15;
        byArray2[22] = 15;
        byArray2[23] = 15;
        byArray2[25] = 16;
        byArray2[26] = 17;
        byArray2[27] = 12;
        byArray2[29] = 18;
        byArray2[30] = 19;
        byArray2[31] = 14;
        byArray2[33] = 20;
        byArray2[34] = 21;
        byArray2[35] = 13;
        byArray2[37] = 19;
        byArray2[38] = 21;
        byArray2[39] = 17;
        byArray2[41] = 18;
        byArray2[42] = 20;
        byArray2[43] = 16;
        byArray2[45] = 11;
        byArray2[46] = 14;
        byArray2[47] = 12;
        byArray2[49] = 12;
        byArray2[50] = 10;
        byArray2[51] = 11;
        byArray2[53] = 11;
        byArray2[54] = 14;
        byArray2[55] = 15;
        byArray2[57] = 14;
        byArray2[58] = 10;
        byArray2[59] = 15;
        byArray2[61] = 11;
        byArray2[62] = 10;
        byArray2[63] = 15;
        fullColorMap = byArray2;
        modePaletteMaps = new byte[36864];
        BaseBK001x.setMonochromeColor((byte)15);
        BaseBK001x.fillMPMEntry(1, monoColorMap, 0);
        int i = 0;
        while (i < 16) {
            BaseBK001x.fillMPMEntry(2 + i, fullColorMap, i * 4);
            ++i;
        }
    }

    void readRom(String name, int addr, int length) {
        String romPath = String.valueOf(PathStrings.romsPath) + name;
        BootLog.l("Loading ROM file %s", romPath);
        length = length + 1 >> 1;
        try {
            FileInputStream ms = new FileInputStream(romPath);
            int i = 0;
            while (i < length) {
                this.memory[addr++] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
                ++i;
            }
            ms.close();
        }
        catch (FileNotFoundException e) {
            BootLog.l("Cannot find ROM file %s; %s", name, e.getMessage());
            System.exit(510);
        }
        catch (IOException e) {
            BootLog.l("Cannot access ROM file %s; %s", name, e.getMessage());
            System.exit(511);
        }
    }

    protected void mapLongPage(int longSlot, int offset, boolean writeable) {
        int shortSlot = longSlot << 2;
        int pages = 4;
        int i = 0;
        while (i < pages) {
            this.mMap[i + shortSlot] = offset;
            offset += 1024;
            ++i;
        }
        int pageMask = pageMasks[longSlot];
        this.mmapReadable |= pageMask;
        this.mmapWriteable = writeable ? (this.mmapWriteable |= pageMask) : (this.mmapWriteable &= ~pageMask);
        this.mmapSpecial = this.mmapSpecial & ~pageMask | Integer.MIN_VALUE;
    }

    void doClassic11MMap(short data) {
        this.sysmmapreg = data;
        if (!this.disableSlot100) {
            int romSel = data & 0x1B;
            if (romSel != 0) {
                if ((romSel & 1) != 0) {
                    this.mapLongPage(4, 94208, false);
                    this.mapLongPage(5, 98304, false);
                } else if ((romSel & 2) != 0) {
                    this.mapLongPage(4, 90112, false);
                    this.mapLongPage(5, 86016, false);
                } else {
                    this.mmapReadable &= ~(pageMasks[4] | pageMasks[5]);
                    this.mmapWriteable &= ~(pageMasks[4] | pageMasks[5]);
                }
            } else {
                int ramSel = data >> 8 & 7;
                int ramAddr = (ramSel ^ 6) << 13;
                this.mapLongPage(4, ramAddr, true);
                this.mapLongPage(5, ramAddr + 4096, true);
            }
        }
        int ramSel = data >> 12 & 7;
        int ramAddr = (ramSel ^ 6) << 13;
        this.mapLongPage(2, ramAddr, true);
        this.mapLongPage(3, ramAddr + 4096, true);
    }

    public BaseBK001x(Mouse mouse, boolean useSMKROM) {
        this.mouse = mouse;
        this.setBASIC10Model();
        int i = 0;
        while (i < 16384) {
            this.memory[i] = (short)(((i >> 7 ^ i) & 1) == 1 ? -1 : 0);
            ++i;
        }
        this.readRom("monit10.rom", 65536, 8192);
        this.readRom("basic10.rom", 69632, 24448);
        this.readRom("b11m_bos.rom", 81920, 8192);
        this.readRom("b11m_ext.rom", 86016, 8192);
        this.readRom("bas11m_0.rom", 94208, 16384);
        this.readRom("bas11m_1.rom", 90112, 8192);
        if (useSMKROM) {
            this.readRom("smk512.rom", 102400, 4096);
        } else {
            this.readRom("fdd.rom", 102400, 4096);
        }
        this.plugins.add(this.keyboard);
        this.plugins.add(this.timer);
        this.plugins.add(this.sregs);
    }

    public void setSynths(AY8910 synthA, AY8910 synthB) {
        this.synthA = synthA;
        this.synthB = synthB;
    }

    public void setTapeReader(WaveReader rdr) {
        this.tapeRdr = rdr;
    }

    @Override
    public void setBase10Model() {
        this.is11M = false;
        this.mapLongPage(0, 0, true);
        this.mapLongPage(1, 4096, true);
        this.mapLongPage(2, 8192, true);
        this.mapLongPage(3, 12288, true);
        this.mapLongPage(4, 65536, false);
        this.mmapReadable &= 0xFFFFF;
    }

    @Override
    public void setFDD10Model() {
        this.setBase10Model();
        this.mapLongPage(5, 16384, true);
        this.mapLongPage(6, 20480, true);
        this.mapLongPage(7, 102400, false);
        this.page160length = 4096;
    }

    @Override
    public void setBASIC10Model() {
        this.setBase10Model();
        this.mapLongPage(5, 69632, false);
        this.mapLongPage(6, 73728, false);
        this.mapLongPage(7, 77824, false);
        this.mmapReadable |= Integer.MIN_VALUE;
        this.page160length = 8064;
    }

    public void setFDD11MModel() {
        this.is11M = true;
        this.mapLongPage(0, 0, true);
        this.mapLongPage(1, 4096, true);
        int addr = 49152;
        this.mapLongPage(2, addr, true);
        this.mapLongPage(3, addr + 4096, true);
        addr = 32768;
        this.mapLongPage(4, addr, true);
        this.mapLongPage(5, addr + 4096, true);
        this.mapLongPage(6, 81920, false);
        this.mapLongPage(7, 102400, false);
        this.page160length = 4096;
    }

    public void setSMK11Model() {
        this.setFDD11MModel();
        this.is11SMK = true;
        this.setSMKMode((short)112, true);
    }

    protected boolean setSMKMode(short data, boolean force) {
        if (!this.is11SMK) {
            return false;
        }
        boolean doUpdate = force;
        if (!force) {
            if (this.smkCREnabled) {
                if ((data & 0xF) != 6) {
                    this.smkCREnabled = false;
                }
                doUpdate = true;
            } else {
                if ((data & 0xF) == 6) {
                    this.smkCREnabled = true;
                    return true;
                }
                return false;
            }
        }
        this.oldSMKCR = data;
        if (!doUpdate) {
            return false;
        }
        this.disableSlot100 = false;
        this.doClassic11MMap(this.sysmmapreg);
        int seg = 0;
        seg |= data & 0xD;
        seg |= data >> 9 & 2;
        seg = (seg << 14) + 106496;
        this.page160length = 7680;
        int page170ofs = seg + 12288 + 2048;
        switch (data >> 4 & 7) {
            case 0: {
                this.mapLongPage(6, seg + 8192, true);
                this.mapLongPage(7, seg + 12288, true);
                return true;
            }
            case 1: {
                this.mapLongPage(4, seg + 8192, true);
                this.mapLongPage(5, seg + 12288, true);
                this.mapLongPage(6, seg + 0, true);
                this.mapLongPage(7, seg + 4096, true);
                this.disableSlot100 = true;
                return true;
            }
            case 2: {
                this.mapLongPage(6, seg + 8192, true);
                this.mapLongPage(7, seg + 12288, true);
                return true;
            }
            case 3: {
                this.mapLongPage(5, seg + 4096, true);
                this.mapLongPage(6, seg + 8192, true);
                this.mapLongPage(7, 102400, false);
                this.mmapReadable &= 0xFFF0FFFF;
                this.mmapWriteable &= 0xFFF0FFFF;
                this.disableSlot100 = true;
                break;
            }
            case 4: {
                this.mapLongPage(4, seg + 0, true);
                this.mapLongPage(5, seg + 4096, true);
                this.mapLongPage(6, seg + 8192, true);
                this.mapLongPage(7, seg + 12288, true);
                this.disableSlot100 = true;
                this.mmapWriteable &= 0xFFF0FFFF;
                return true;
            }
            case 5: {
                this.mapLongPage(4, seg + 0, true);
                this.mapLongPage(5, seg + 4096, true);
                this.mapLongPage(6, seg + 8192, true);
                this.mapLongPage(7, seg + 12288, true);
                this.disableSlot100 = true;
                return true;
            }
            case 6: {
                this.mapLongPage(6, 81920, false);
                this.mapLongPage(7, 102400, false);
                break;
            }
            case 7: {
                this.page160length = 8192;
                this.mapLongPage(5, seg + 12288, true);
                this.mapLongPage(6, seg, true);
                this.mapLongPage(7, 102400, false);
                this.mMap[30] = this.mMap[28];
                this.mMap[31] = this.mMap[29];
                this.disableSlot100 = true;
                this.mmapReadable |= 0xC0000000;
                this.mmapReadable &= 0xFFF0FFFF;
                this.mmapWriteable &= 0xFFF0FFFF;
                return true;
            }
        }
        this.mMap[30] = page170ofs;
        this.mMap[31] = page170ofs + 1024;
        this.mmapReadable |= 0xC0000000;
        this.mmapWriteable |= 0xC0000000;
        return true;
    }

    @Override
    public boolean setMemoryModelByFDCBits(short data) {
        if (this.is11SMK) {
            this.setSMKMode(data, false);
            return (data & 4) == 0;
        }
        if (this.is11M) {
            return true;
        }
        boolean isReadable = true;
        switch (data & 0xC) {
            case 12: {
                this.setBASIC10Model();
                isReadable = false;
                break;
            }
            case 8: {
                this.setBase10Model();
                break;
            }
            default: {
                this.setFDD10Model();
            }
        }
        return isReadable;
    }

    public void attach(QBusSlave plugin) {
        this.plugins.add(plugin);
    }

    public void addObserver(QBusObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(QBusObserver observer) {
        this.observers.remove(observer);
    }

    protected void checkMouseReset(int data) {
        boolean newReset;
        boolean bl = newReset = (data & 8) != 0;
        if (newReset) {
            this.mouse.consumeMove();
        }
        this.oldMouseReset = newReset;
    }

    @Override
    public boolean readWord(int addr, QBusReadDTO result, boolean opcode) {
        int ia = addr &= 0xFFFF;
        int page = ia >> 11;
        int pageMask = 1 << page;
        int mapped = this.mMap[page] + ((ia & 0x7FF) >> 1);
        for (QBusObserver observer : this.observers) {
            observer.memoryAccessNotification(addr, opcode ? 2 : 1, 0);
        }
        if ((this.mmapSpecial & pageMask) == 0) {
            if (ia < 57344 + this.page160length && (this.mmapReadable & pageMask) != 0) {
                result.value = this.memory[mapped];
                return true;
            }
            return super.readWord(addr, result, opcode);
        }
        boolean replied = false;
        result.value = 0;
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            replied |= plugin.readWord(addr, result, false);
            break;
        }
        if ((this.mmapReadable & pageMask) != 0 && ia < 57344 + this.page160length) {
            result.value = (short)(result.value | this.memory[mapped]);
            return true;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            result.value = (short)(result.value | (short)(this.ioreadreg | this.joystick.getIO() | this.mouse.getIO()));
            return true;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            int tape = 32;
            if (this.tapeRdr != null) {
                long cyc = this.ts.getCycles();
                long delta = cyc - this.lastTape;
                if ((this.syswritereg & 0x80) != 0) {
                    delta = 0L;
                }
                this.lastTape = cyc;
                if (delta + (long)this.tapeDelay < 272L) {
                    this.tapeDelay = (int)((long)this.tapeDelay + delta);
                    tape &= this.tapeRdr.lastSample();
                } else if (delta < 27200000L) {
                    this.tapeDelay = (int)((long)this.tapeDelay + delta);
                    while (this.tapeDelay >= 272) {
                        this.tapeRdr.nextSample();
                        this.tapeDelay -= 272;
                    }
                    tape &= this.tapeRdr.lastSample();
                } else {
                    this.tapeDelay = 0;
                    tape &= this.tapeRdr.nextSample();
                }
            }
            result.value = (short)(result.value | (short)(tape | (this.keyboard.getKeyDown() ? 0 : 64) | (this.is11M ? 49280 : 32912) | this.syswritereg & 8));
            this.syswritereg = (short)(this.syswritereg & 0xFFFFFFF7);
            return true;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            result.value = (short)(result.value | this.scrollReg);
            return true;
        }
        if (replied) {
            return true;
        }
        return super.readWord(addr, result, opcode);
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        int ia = addr &= 0xFFFF;
        int page = ia >> 11;
        int pageMask = 1 << page;
        int mapped = this.mMap[page] + ((ia & 0x7FF) >> 1);
        for (QBusObserver observer : this.observers) {
            observer.memoryAccessNotification(addr, 3, data);
        }
        this.updateRaster();
        if ((this.mmapSpecial & pageMask) == 0) {
            if (ia < 57344 + this.page160length && (this.mmapWriteable & pageMask) != 0) {
                this.memory[mapped] = (ia & 1) == 0 ? (short)(this.memory[mapped] & 0xFF00 | data & 0xFF) : (short)(this.memory[mapped] & 0xFF | data & 0xFF00);
                return true;
            }
            return super.writeWord(addr, data);
        }
        if (this.is11M && (ia & 0xFFFFFFFE) == 65458) {
            this.paletteReg = data;
            return true;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            return plugin.writeByteAsWord(addr, data);
        }
        if ((this.mmapWriteable & pageMask) != 0 && ia < 57344 + this.page160length) {
            this.memory[mapped] = (ia & 1) == 0 ? (short)(this.memory[mapped] & 0xFF00 | data & 0xFF) : (short)(this.memory[mapped] & 0xFF | data & 0xFF00);
            return true;
        }
        if (ia == 65484) {
            this.checkMouseReset(data);
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            if (this.ioLoopback) {
                this.ioreadreg = (ia & 1) == 0 ? (short)(this.ioreadreg & 0xFF00 | data & 0xFF) : (short)(this.ioreadreg & 0xFF | data & 0xFF00);
            }
            if ((ia & 1) == 0) {
                if (this.srend != null) {
                    this.srend.catchUp();
                    if (this.covoxEnabled) {
                        if (this.covoxSmart) {
                            if (((this.iowritereg ^ data) & 0xFF) != 8 && this.covoxByte) {
                                this.srend.updateCovox(data);
                            }
                            this.covoxByte = true;
                        } else {
                            this.srend.updateCovox(data);
                        }
                    }
                    if (this.synthA != null) {
                        this.synthA.writeReg((byte)(~data));
                    }
                }
                this.iowritereg = (short)(this.iowritereg & 0xFF00 | data & 0xFF);
            } else {
                this.iowritereg = (short)(this.iowritereg & 0xFF | data & 0xFF00);
            }
            return true;
        }
        if (ia == 65486) {
            this.syswritereg = (short)(this.syswritereg & 0xFF00 | data & 0xFF | 8);
            if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return true;
        }
        if (ia == 65487) {
            this.syswritereg = (short)(this.syswritereg & 0xFF | data & 0xFF00 | 8);
            return true;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            int mask = (ia & 1) != 0 ? 65280 : 255;
            this.scrollReg = (short)(data & 0x2FF | mask);
            return true;
        }
        return super.writeByteAsWord(addr, data);
    }

    @Override
    public boolean writeWord(int addr, short data) {
        int ia = addr &= 0xFFFF;
        int page = ia >> 11;
        int pageMask = 1 << page;
        int mapped = this.mMap[page] + ((ia & 0x7FF) >> 1);
        for (QBusObserver observer : this.observers) {
            observer.memoryAccessNotification(addr, 0, data);
        }
        this.updateRaster();
        if ((this.mmapSpecial & pageMask) == 0) {
            if (ia < 57344 + this.page160length && (this.mmapWriteable & pageMask) != 0) {
                this.memory[mapped] = data;
                return true;
            }
            return super.writeWord(addr, data);
        }
        if (this.is11M && (ia & 0xFFFFFFFE) == 65458) {
            this.paletteReg = data;
            return true;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            return plugin.writeWord(addr, data);
        }
        boolean wasWritten = false;
        if (ia < 57344 + this.page160length && (this.mmapWriteable & pageMask) != 0) {
            this.memory[mapped] = data;
            wasWritten = true;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            if (this.ioLoopback) {
                this.ioreadreg = data;
            }
            this.checkMouseReset(data);
            if (this.srend != null) {
                if (this.covoxEnabled) {
                    if (this.covoxSmart) {
                        if (((this.iowritereg ^ data) & 0xFF) != 8 && !this.covoxByte) {
                            this.srend.updateCovox(data);
                        }
                        this.covoxByte = false;
                    } else {
                        this.srend.updateCovox(data);
                    }
                }
                if (this.synthA != null) {
                    this.synthA.setRegIndex(~data & 0xFF);
                }
            }
            this.iowritereg = data;
            return true;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.is11M && (data & 0x800) != 0) {
                this.doClassic11MMap(data);
            } else {
                this.syswritereg = (short)(data | 8);
                if (this.srend != null) {
                    this.srend.updateBit(data & 0x40);
                }
            }
            return true;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            this.scrollReg = (short)(data & 0x2FF);
            return true;
        }
        if (wasWritten) {
            return true;
        }
        return super.writeWord(addr, data);
    }

    @Override
    public int getBaseAddress() {
        return 0;
    }

    @Override
    public int getNumWords() {
        return 32768;
    }

    @Override
    public boolean gotInterrupt() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte interruptVector() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return plugin.interruptVector();
        }
        return -1;
    }

    public void coldReset() {
        if (this.is11SMK) {
            this.setSMK11Model();
        }
        this.reset();
    }

    @Override
    public void reset() {
        for (QBusSlave plugin : this.plugins) {
            plugin.reset();
        }
        if (this.synthA != null) {
            this.synthA.reset();
        }
        if (this.synthB != null) {
            this.synthB.reset();
        }
    }

    public boolean timerEnabled() {
        return (this.paletteReg & 0x4000) == 0;
    }

    public boolean stopKeyEnabled() {
        return (this.syswritereg & 0x1000) == 0;
    }

    public void setSoundRenderer(SoundRenderer sr) {
        this.srend = sr;
    }

    public void setCovoxMode(int mode) {
        switch (mode) {
            case 1: {
                this.covoxSmart = false;
                this.covoxEnabled = true;
                this.ioLoopback = false;
                break;
            }
            case 2: {
                this.covoxSmart = true;
                this.covoxEnabled = true;
                this.ioLoopback = false;
                break;
            }
            case 3: {
                this.covoxSmart = false;
                this.covoxEnabled = true;
                this.ioLoopback = true;
                break;
            }
            default: {
                this.covoxEnabled = false;
            }
        }
    }

    public void cycleVideomodes() {
        this.forceGray = false;
        this.videoMode = this.is11M ? (this.videoMode == 2 ? 0 : 2) : (this.videoMode >= 2 ? 0 : this.videoMode + 1);
        this.updateRaster();
    }

    public void forceGray() {
        this.forceGray = true;
        this.videoMode = 1;
        this.updateRaster();
    }

    public void setRaster(byte[] aRaster) {
        this.raster = aRaster;
        this.lastVidPos = 0;
    }

    public void setTimeSource(TimeSource ts, int freq) {
        this.ts = ts;
        this.cpw = freq / 750000;
        this.cpl = this.cpw * 48;
        this.cpf = this.cpw * 15360;
        this.lastCycles = this.lastFullFrame = ts.getCycles();
        this.lastBeamPos = 0;
        this.lastSubPos = 0;
        this.lastVidPos = 0;
        this.scrollPos = (this.scrollReg + 40 & 0xFF) * 32;
    }

    public boolean updateRaster() {
        int newVidPos;
        int newBeamPos;
        long cycles = this.ts.getCycles();
        long step = cycles - this.lastCycles + (long)this.lastSubPos;
        if (step < (long)this.cpw) {
            return false;
        }
        if (step >= (long)this.cpf) {
            this.frameCounter = (int)((long)this.frameCounter + step / (long)this.cpf);
            this.lastSubPos = (int)(step %= (long)this.cpf) % this.cpw;
            newBeamPos = this.lastBeamPos + (int)step / this.cpw;
            newVidPos = 8192;
        } else {
            this.lastSubPos = (int)step % this.cpw;
            newBeamPos = this.lastBeamPos + (int)step / this.cpw;
            int y = newBeamPos / 48;
            int x = newBeamPos % 48;
            y = Math.max(y - 40, 0);
            x = Math.max(Math.min(x - 12, 31), 0);
            newVidPos = Math.min(x + y * 32, 8192);
        }
        if (this.lastBeamPos < 13440 && newBeamPos >= 13440 || this.lastBeamPos > newBeamPos) {
            this.scrollPos = (this.scrollReg + 40 & 0xFF) * 32;
        }
        this.lastBeamPos = newBeamPos;
        if (newVidPos > this.lastVidPos) {
            int base = this.is11M && (this.paletteReg & 0x8000) == 0 ? 57344 : 8192;
            int src = this.scrollPos + this.lastVidPos & 0x1FFF;
            int dst = this.lastVidPos * 16;
            int limit = (this.scrollReg & 0x200) == 0 ? 64 : 256;
            int cmap = this.is11M && this.videoMode == 2 ? 2 + (this.paletteReg >> 8 & 0xF) : this.videoMode;
            cmap *= 2048;
            limit = Math.min(limit * 32, newVidPos) - this.lastVidPos;
            this.lastVidPos += limit;
            while (limit-- > 0) {
                int s = this.memory[base + src++] & 0xFFFF;
                System.arraycopy(modePaletteMaps, cmap + ((s & 0xFF) << 3), this.raster, dst, 8);
                System.arraycopy(modePaletteMaps, cmap + (s >> 8 << 3), this.raster, dst += 8, 8);
                dst += 8;
                src &= 0x1FFF;
            }
            if (this.lastVidPos < newVidPos) {
                Arrays.fill(this.raster, dst, newVidPos * 16, (byte)0);
            }
            this.lastVidPos = newVidPos;
        }
        this.lastCycles = cycles;
        if (this.lastBeamPos >= 15360) {
            this.frameCounter += this.lastBeamPos / 15360;
            this.lastBeamPos %= 15360;
            this.lastVidPos = 0;
        }
        return false;
    }

    public int getFrameCounter() {
        return this.frameCounter;
    }

    public List<HeartbeatListener> getHeartbeatListeners() {
        ArrayList<HeartbeatListener> result = new ArrayList<HeartbeatListener>();
        for (QBusSlave slave : this.plugins) {
            if (!(slave instanceof HeartbeatListener)) continue;
            result.add((HeartbeatListener)((Object)slave));
        }
        return result;
    }

    private static void fillMPMEntry(int ofs, byte[] cmap, int mapofs) {
        ofs = ofs * 256 << 3;
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 8) {
                byte col = cmap[(i >> j & 3) + mapofs];
                BaseBK001x.modePaletteMaps[ofs++] = col;
                BaseBK001x.modePaletteMaps[ofs++] = col;
                j += 2;
            }
            ++i;
        }
    }

    public static void setMonochromeColor(byte monoColor) {
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 8) {
                BaseBK001x.modePaletteMaps[(i << 3) + j] = (i >> j & 1) != 0 ? monoColor : (byte)0;
                ++j;
            }
            ++i;
        }
    }
}

