/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PaletteSelectorWindow
extends JFrame {
    static final int DEFAULT_SIZE = 20;
    ColorIcon[] paletteIcons;
    int[] paletteColors = Arrays.copyOf(defaultColors, 4);
    Color[] paletteColorRefs = new Color[4];
    Color[] paletteGradientColorRefs = new Color[4];
    boolean gradientEnabled;
    static final int COLOR_COUNT = 4;
    static int[] defaultColors;
    static final String[] grbColorNames;
    static final int[] grbColors;
    static final int[] gradientMasks;
    static ColorIcon[] grbIcons;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 2;
        defaultColors = nArray;
        grbColorNames = new String[]{"Black", "Blue", "Red", "Magenta", "Green", "Cyan", "Yellow", "White"};
        int[] nArray2 = new int[8];
        nArray2[1] = 255;
        nArray2[2] = 0xFF0000;
        nArray2[3] = 0xFF00FF;
        nArray2[4] = 65280;
        nArray2[5] = 65535;
        nArray2[6] = 0xFFFF00;
        nArray2[7] = 0xFFFFFF;
        grbColors = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 0x555555;
        nArray3[2] = 0xAAAAAA;
        nArray3[3] = 0xFFFFFF;
        gradientMasks = nArray3;
        grbIcons = new ColorIcon[grbColors.length];
        int i = 0;
        while (i < grbColors.length) {
            PaletteSelectorWindow.grbIcons[i] = new ColorIcon(20, 20, grbColors[i]);
            ++i;
        }
    }

    public PaletteSelectorWindow() {
        super("Extended palette");
        this.paletteIcons = new ColorIcon[4];
        int i = 0;
        while (i < 4) {
            Color cRef;
            ColorIcon ci;
            this.paletteIcons[i] = ci = grbIcons[defaultColors[i]].clone();
            this.paletteColorRefs[i] = cRef = ci.color;
            this.paletteGradientColorRefs[i] = new Color(cRef.getRGB() & gradientMasks[i]);
            ++i;
        }
        Box topBox = Box.createVerticalBox();
        Box palBox = Box.createHorizontalBox();
        ColorIcon[] colorIconArray = this.paletteIcons;
        int n = this.paletteIcons.length;
        int n2 = 0;
        while (n2 < n) {
            ColorIcon colorIcon = colorIconArray[n2];
            palBox.add(new JLabel(colorIcon));
            ++n2;
        }
        JCheckBox gradientCB = new JCheckBox("Gradient");
        gradientCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean changed = false;
                boolean gradient = false;
                if (e.getStateChange() == 1) {
                    gradient = true;
                    changed = true;
                } else if (e.getStateChange() == 2) {
                    gradient = false;
                    changed = true;
                }
                if (changed) {
                    PaletteSelectorWindow.this.gradientEnabled = gradient;
                    Color[] cRefs = gradient ? PaletteSelectorWindow.this.paletteGradientColorRefs : PaletteSelectorWindow.this.paletteColorRefs;
                    int i = 0;
                    while (i < 4) {
                        PaletteSelectorWindow.this.paletteIcons[i].setColor(cRefs[i]);
                        ++i;
                    }
                    PaletteSelectorWindow.this.repaint();
                }
            }
        });
        palBox.add(gradientCB);
        topBox.add(palBox);
        Box csBox = Box.createHorizontalBox();
        int paletteIndex = 1;
        while (paletteIndex < 4) {
            JPanel csp = new JPanel(false);
            csp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Color " + paletteIndex));
            csp.setLayout(new BoxLayout(csp, 1));
            ButtonGroup csbg = new ButtonGroup();
            int colorIndex = 0;
            while (colorIndex < grbColors.length) {
                TaggedRadioButton rb = new TaggedRadioButton(paletteIndex | colorIndex << 8, grbColorNames[colorIndex], colorIndex == defaultColors[paletteIndex]);
                rb.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            int tag = ((TaggedRadioButton)e.getItem()).getTag();
                            PaletteSelectorWindow.this.notifySelection(tag & 0xFF, tag >> 8);
                        }
                    }
                });
                csbg.add(rb);
                csp.add(rb);
                ++colorIndex;
            }
            csBox.add(csp);
            ++paletteIndex;
        }
        topBox.add(csBox);
        this.add(topBox);
        this.pack();
        this.setVisible(true);
    }

    void notifySelection(int paletteIndex, int colorIndex) {
        if (this.paletteColors[paletteIndex] == colorIndex) {
            return;
        }
        this.paletteColors[paletteIndex] = colorIndex;
        int packedColor = grbColors[colorIndex];
        Color cRef = this.paletteColorRefs[paletteIndex] = new Color(packedColor);
        Color cGRef = this.paletteGradientColorRefs[paletteIndex] = new Color(packedColor & gradientMasks[paletteIndex]);
        this.paletteIcons[paletteIndex].setColor(this.gradientEnabled ? cGRef : cRef);
        this.repaint();
    }

    public static void main(String[] args) {
        PaletteSelectorWindow psw = new PaletteSelectorWindow();
        psw.setDefaultCloseOperation(3);
    }

    static class ColorIcon
    implements Icon,
    Cloneable {
        int width;
        int height;
        Color color;
        int packedColor;

        public ColorIcon(int width, int height, Color color) {
            this.width = width;
            this.height = height;
            this.color = color == null ? Color.BLACK : color;
        }

        public ColorIcon(int width, int height, int color) {
            this.width = width;
            this.height = height;
            this.color = new Color(color);
            this.packedColor = color;
        }

        private ColorIcon(int width, int height, Color color, int packed) {
            this.width = width;
            this.height = height;
            this.color = color;
            this.packedColor = packed;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saveC = g.getColor();
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.width, this.height);
            g.setColor(this.color);
            g.fillRect(1, 1, this.width - 1, this.height - 1);
            g.setColor(saveC);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        public void setColor(Color newColor) {
            if (newColor == null) {
                newColor = Color.BLACK;
            }
            this.color = newColor;
            this.packedColor = newColor.getRGB();
        }

        public void setColor(int newColor) {
            this.color = new Color(newColor);
            this.packedColor = newColor;
        }

        protected ColorIcon clone() {
            return new ColorIcon(this.width, this.height, this.color, this.packedColor);
        }
    }

    static class TaggedRadioButton
    extends JRadioButton {
        int tag;

        public TaggedRadioButton(int tag, String text, boolean selected) {
            super(text, selected);
            this.tag = tag;
        }

        public int getTag() {
            return this.tag;
        }
    }
}

