/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui20;

import bk2010.gui.debugger.ui20.LineListModel;
import bk2010.hardware.cpu.Disasm;
import bk2010.hardware.cpu.K1801VM1;
import java.util.Arrays;

public class CPURegistersModel
implements LineListModel {
    private K1801VM1 cpu;
    public static final int PSW_WIDTH = 11;
    public static final int PSW_BITMASK = 2047;
    public static final String PSW_BITNAMES = "  HI  TNZVC";

    public CPURegistersModel(K1801VM1 cpu) {
        this.cpu = cpu;
    }

    @Override
    public int size() {
        return 10;
    }

    @Override
    public int getExpectedWidth() {
        return 11;
    }

    @Override
    public String get(int index) {
        if (index < 0 || index > 10) {
            return "";
        }
        if (index == 9) {
            char[] buf = new char[11];
            Arrays.fill(buf, ' ');
            int psw = this.cpu.psw & 0x7FF;
            int i = 10;
            while (psw != 0) {
                if ((psw & 1) != 0) {
                    buf[i] = PSW_BITNAMES.charAt(i);
                }
                --i;
                psw >>= 1;
            }
            return new String(buf);
        }
        if (index == 8) {
            return String.format("PSW: %06o", this.cpu.psw & 0xFFFF);
        }
        return String.format("%2s = %06o", Disasm.getRegName(index), this.cpu.regs[index] & 0xFFFF);
    }
}

