/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.helpers.Tools;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.cpu.K1801VM1;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class StackView
extends JComponent {
    private static final long serialVersionUID = 3230601056609591194L;
    static int MAX_ROWS = 31;
    int rowHeight;
    int baseOffset;
    int pad = 2;
    int preferredRows = 10;
    private K1801VM1 cpu;
    private QBusProxy memory;

    public StackView(K1801VM1 cpu, QBusProxy memory) {
        this.cpu = cpu;
        this.memory = memory;
        this.setFont(Tools.monoFont);
        int prefWidth = Tools.fontWidth * 11 + this.pad + this.pad;
        this.rowHeight = Tools.fontHeight + this.pad + this.pad;
        int prefHeight = this.rowHeight * (this.preferredRows + 2);
        int maxHeight = this.rowHeight * (MAX_ROWS + 2);
        this.baseOffset = Tools.fontBase + this.pad;
        this.setMinimumSize(new Dimension(prefWidth, this.rowHeight * 3));
        this.setMaximumSize(new Dimension(prefWidth, maxHeight));
        this.setPreferredSize(new Dimension(prefWidth, prefHeight));
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        int lineHeight = this.rowHeight;
        int startY = this.baseOffset;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.getFont());
        QBusReadDTO dto = new QBusReadDTO();
        g.drawString("---Stack---", this.pad, startY);
        int addr = this.cpu.regs[6] & 0xFFFE;
        String buf = String.format(" At %06o", addr);
        g.drawString(buf, this.pad, startY += this.rowHeight);
        startY += this.rowHeight;
        int rows = Math.min(Math.max(this.getHeight() / this.rowHeight - 2, 1), MAX_ROWS);
        int index = 0;
        while (index < rows) {
            buf = !this.memory.readWord(addr + index * 2, dto, false) ? String.format("+%02o: ------", index * 2) : String.format("+%02o: %06o", index * 2, dto.value & 0xFFFF);
            g.drawString(buf, this.pad, startY);
            startY += lineHeight;
            ++index;
        }
    }
}

