/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.MemoryView;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusProxy;
import bk2010.io.Mouse;
import java.awt.BorderLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MemoryPanel
extends JPanel {
    private static final long serialVersionUID = -987489298492415729L;
    MemoryView memoryView;

    public MemoryPanel(QBusProxy memory) {
        super(new BorderLayout());
        this.memoryView = new MemoryView(memory);
        JScrollPane memoryScroll = new JScrollPane(this.memoryView, 22, 31);
        memoryScroll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(memoryScroll);
    }

    public void selectAddress(int addr) {
        this.memoryView.setSelectedAddr(addr);
        this.memoryView.ensureVisible(addr);
    }

    public void ensureVisible(int addr) {
        this.memoryView.ensureVisible(addr);
    }

    public static void main(String[] args) throws IOException {
        JFrame fr = new JFrame("Memory15 test");
        fr.setDefaultCloseOperation(3);
        BaseBK001x machine = new BaseBK001x(new Mouse(), false);
        TimeSource stillTime = new TimeSource(){

            @Override
            public long getCycles() {
                return 0L;
            }
        };
        machine.setTimeSource(stillTime, 1000000);
        machine.timer.setTimeSource(stillTime);
        fr.add(new MemoryPanel(machine));
        fr.pack();
        fr.setVisible(true);
    }
}

