/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.debugger.ui15.LabelsModel;
import bk2010.gui.helpers.Tools;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class LabelsView
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    static final int MAX_ROWS = 25000;
    AddressCallback callback;
    LabelsModel model;
    int labelWidth = 10;
    String labelFormat = "%10s = %06o";
    int dataRowCount = 0;
    int preferredColumns;
    int preferredRows = 10;
    int preferredWidth;
    Dimension preferredSize;
    Dimension totalSize;
    int pad = 2;
    int fontHeight;
    int rowHeight;
    int fontBaseline;
    int totalHeight;

    public LabelsView(LabelsModel model, AddressCallback callback) {
        this.callback = callback;
        this.model = model;
        this.setFont(Tools.monoFont);
        this.fontHeight = Tools.fontHeight;
        this.refreshModel(true);
    }

    public void refreshModel(boolean force) {
        this.dataRowCount = this.model.size();
        int labelChars = 10;
        int maxChars = 20;
        for (LabelsModel.LabelRecord label : this.model.records) {
            labelChars = Math.min(maxChars, Math.max(labelChars, label.name.length()));
        }
        if (force || labelChars != this.labelWidth) {
            this.labelFormat = String.format("%%%ds = %%06o", labelChars);
            this.preferredWidth = Tools.fontWidth * (this.labelWidth + 3 + 6) + this.pad + this.pad;
            this.rowHeight = Tools.fontHeight + this.pad + this.pad;
            this.totalHeight = this.rowHeight * this.model.size();
            this.fontBaseline = Tools.fontBase;
            this.labelWidth = labelChars;
            this.preferredWidth = Tools.fontWidth * (this.labelWidth + 3 + 6) + this.pad + this.pad;
            int prefHeight = this.rowHeight * (this.preferredRows + 1);
            this.preferredSize = new Dimension(this.preferredWidth, prefHeight);
            this.totalSize = new Dimension(this.preferredWidth, this.totalHeight);
            this.setMinimumSize(new Dimension(this.preferredWidth, this.rowHeight * 3));
            this.setMaximumSize(this.totalSize);
            this.setPreferredSize(this.totalSize);
        }
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LabelsView.this.postSelectionEvent(e.getY());
                }
            }
        });
        this.revalidate();
        this.repaint();
    }

    void postSelectionEvent(int y) {
        Rectangle vis = this.getVisibleRect();
        int line = Math.max((vis.y + y) / this.rowHeight, 0);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight * 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle vis = this.getVisibleRect();
        int firstLine = Math.max(vis.y / this.rowHeight, 0);
        int lastLine = Math.min((vis.y + vis.height + this.rowHeight - 1) / this.rowHeight, this.dataRowCount - 1);
        if (lastLine < firstLine) {
            return;
        }
        int i = firstLine;
        while (i <= lastLine) {
            int y = i * this.rowHeight + this.pad;
            LabelsModel.LabelRecord record = this.model.records.get(i);
            String name = record.name;
            if (name.length() > this.labelWidth) {
                name = String.valueOf(name.substring(0, this.labelWidth - 2)) + "..";
            }
            String text = String.format(this.labelFormat, name, record.address);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawString(text, 0, y + this.fontBaseline);
            ++i;
        }
    }
}

