/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.DisasmModel;
import bk2010.gui.helpers.Tools;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class DisasmView
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = -5391332494503602378L;
    static final int TOTAL_MEMWORDS = 32768;
    DisasmModel disasmModel;
    int preferredColumns;
    int preferredRows = 30;
    int preferredWidth;
    Dimension preferredSize;
    Dimension totalSize;
    int pad = 2;
    int fontHeight;
    int rowHeight;
    int fontBaseline;
    int totalHeight;
    int selectedRow = 3;

    public DisasmView(DisasmModel disasmModel) {
        this.disasmModel = disasmModel;
        this.preferredColumns = disasmModel.getMaxWidth();
        this.setFont(Tools.monoFont);
        this.fontHeight = Tools.fontHeight;
        this.preferredWidth = Tools.fontWidth * this.preferredColumns + this.pad + this.pad;
        this.rowHeight = this.fontHeight + this.pad + this.pad;
        this.totalHeight = this.rowHeight * 32768;
        this.fontBaseline = Tools.fontBase;
        int prefHeight = this.rowHeight * this.preferredRows;
        this.preferredSize = new Dimension(this.preferredWidth, prefHeight);
        this.totalSize = new Dimension(this.preferredWidth, this.totalHeight);
        this.setMinimumSize(new Dimension(this.preferredWidth, this.rowHeight));
        this.setMaximumSize(this.totalSize);
        this.setPreferredSize(this.totalSize);
    }

    public void ensureVisible(int addr) {
        addr &= 0xFFFE;
        Container parent = this.getParent();
        if (!(parent instanceof JViewport)) {
            return;
        }
        this.scrollRectToVisible(new Rectangle(0, this.rowHeight * (addr >> 1), this.preferredWidth, this.rowHeight * this.preferredRows / 2));
    }

    public void setSelectedAddr(int addr) {
        this.selectedRow = (addr & 0xFFFF) >> 1;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight * 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle vis = this.getVisibleRect();
        int firstLine = Math.max(vis.y / this.rowHeight, 0);
        int lastLine = Math.min((vis.y + vis.height + this.rowHeight - 1) / this.rowHeight, Short.MAX_VALUE);
        if (lastLine < firstLine) {
            return;
        }
        int i = firstLine;
        while (i <= lastLine) {
            int y = i * this.rowHeight + this.pad;
            if (i == this.selectedRow) {
                Color oldColor = g2.getColor();
                g2.setColor(Color.GREEN);
                g2.fillRect(0, y - this.pad, this.getWidth(), this.rowHeight);
                g2.setColor(oldColor);
            }
            String disasm = this.disasmModel.getDisasm(i * 2);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawString(disasm, 0, y + this.fontBaseline);
            ++i;
        }
    }
}

