/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.DisasmModel;
import bk2010.gui.debugger.ui15.DisasmView;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeSource;
import bk2010.io.Mouse;
import java.awt.BorderLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class DisasmPanel
extends JPanel {
    static final long serialVersionUID = -6722239728030900345L;
    DisasmModel disasmModel;
    DisasmView disasmView;
    Border disasmBorder;

    public DisasmPanel(DisasmModel disasmModel) {
        super(new BorderLayout());
        this.disasmModel = disasmModel;
        this.disasmView = new DisasmView(disasmModel);
        JScrollPane disasmScroll = new JScrollPane(this.disasmView, 22, 31);
        disasmScroll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(disasmScroll);
    }

    public void selectAddress(int addr) {
        this.disasmView.setSelectedAddr(addr);
        this.disasmView.ensureVisible(addr);
    }

    public void ensureVisible(int addr) {
        this.disasmView.ensureVisible(addr);
    }

    public void setPC(int addr) {
        this.disasmModel.setPC(addr);
        this.disasmView.setSelectedAddr(addr);
        this.disasmView.ensureVisible(addr);
    }

    public void purge() {
        this.disasmModel.purge();
    }

    public void purgeWord(short addr) {
        this.disasmModel.purgeWord(addr);
    }

    public static void main(String[] args) throws IOException {
        JFrame fr = new JFrame("Disasm15 test");
        fr.setDefaultCloseOperation(3);
        BaseBK001x machine = new BaseBK001x(new Mouse(), false);
        TimeSource stillTime = new TimeSource(){

            @Override
            public long getCycles() {
                return 0L;
            }
        };
        machine.setTimeSource(stillTime, 1000000);
        machine.timer.setTimeSource(stillTime);
        fr.add(new DisasmPanel(new DisasmModel(machine)));
        fr.pack();
        fr.setVisible(true);
    }
}

