/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.cpu.Disasm;
import java.util.Arrays;

public class DisasmModel {
    public static final int FLAGS_LENMASK = 3;
    public static final int FLAGS_INSN = 4;
    public static final int FLAGS_HEAD = 8;
    public static final int FLAGS_IMASK = 15;
    public static final int FLAGS_UNUSED = 65536;
    public static final int FLAGS_PC = 131072;
    private static final int POS_ADDR = 0;
    private static final int POS_CHARS = 8;
    private static final int POS_DATA = 11;
    private static final int POS_RADIX50 = 18;
    private static final int POS_BYTE1 = 22;
    private static final int POS_BYTE2 = 26;
    private static final int POS_DISASM = 32;
    private static final int POS_ANNOT = 61;
    private static final int POS_TERMINAL = 93;
    public static final String RADIX50 = " ABCDEFGHIJKLMNOPQRSTUVWXYZ$._0123456789";
    private QBusProxy memory;
    private QBusReadDTO dto = new QBusReadDTO();
    private int[] memFlags = new int[32768];
    private int pc;

    public DisasmModel(QBusProxy memory) {
        this.memory = memory;
    }

    public void setPC(int addr) {
        this.pc = addr & 0xFFFE;
        this.updateDisassemblyAt(this.pc, true);
    }

    public void updateDisassemblyAt(int addr, boolean force) {
        int index = addr >> 1;
        if (force || (this.memFlags[index] & 0xF) == 0) {
            int len = Disasm.length(this.memory, (short)addr);
            int trail = 0;
            if (len > 0) {
                int pos = index;
                this.memFlags[pos] = this.memFlags[pos] & 0xFFFFFFF0 | 8 | 4 | len--;
                while (len > 0) {
                    int overLength = this.memFlags[pos = pos + 1 & Short.MAX_VALUE] & 3;
                    if (overLength > trail) {
                        trail = overLength;
                    }
                    this.memFlags[pos] = this.memFlags[pos] & 0xFFFFFFF0 | 4 | len--;
                    --trail;
                }
                while (trail-- > 0) {
                    int n = pos = pos + 1 & Short.MAX_VALUE;
                    this.memFlags[n] = this.memFlags[n] & 0xFFFFFFF0;
                }
            }
        }
    }

    public String getDisasm(int addr) {
        int index = (addr &= 0xFFFE) >> 1;
        this.updateDisassemblyAt(addr, false);
        int flags = this.memFlags[index];
        StringBuilder sb = new StringBuilder(93);
        sb.append(String.format("%06o: ", addr));
        if (!this.memory.readWord(addr, this.dto, false)) {
            sb.append("--- Unreadable location ---");
            return sb.toString();
        }
        int tmp = this.dto.value & 0xFFFF;
        sb.append("\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u25a0\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0428\u042d\u0429\u0427\u042a?".charAt(tmp & 0xFF));
        sb.append("\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u25a0\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0428\u042d\u0429\u0427\u042a?".charAt(tmp >> 8 & 0xFF));
        sb.append(String.format(" %06o ", tmp));
        if (tmp > 63999) {
            sb.append("???");
        } else {
            int code = tmp;
            sb.append(RADIX50.charAt(code / 1600));
            sb.append(RADIX50.charAt((code %= 1600) / 40));
            sb.append(RADIX50.charAt(code %= 40));
        }
        sb.append(String.format(" %03o ", tmp & 0xFF));
        sb.append(String.format("%03o ", tmp >> 8 & 0xFF));
        if ((flags & 8) != 0) {
            sb.append(Disasm.disasm(this.memory, (short)addr, false));
        }
        return sb.toString();
    }

    public void purge() {
        Arrays.fill(this.memFlags, 0);
    }

    public void purgeWord(short addr) {
        this.memFlags[addr >> 1 & Short.MAX_VALUE] = 0;
    }

    public int getSize() {
        return 32768;
    }

    public int getMaxWidth() {
        return 93;
    }
}

