/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.helpers.Tools;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.cpu.Disasm;
import bk2010.hardware.cpu.K1801VM1;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class CPURegistersView
extends JComponent {
    private static final long serialVersionUID = -4995692271629717425L;
    public static final int PSW_WIDTH = 11;
    public static final String PSW_BITNAMES = "  HI  TNZVC";
    int rowHeight;
    int baseOffset;
    int rows = 13;
    int pad = 2;
    private K1801VM1 cpu;
    private CPUTimer timer;

    public CPURegistersView(K1801VM1 cpu, CPUTimer timer) {
        this.cpu = cpu;
        this.timer = timer;
        this.setFont(Tools.monoFont);
        int prefWidth = Tools.fontWidth * 11 + this.pad + this.pad;
        this.rowHeight = Tools.fontHeight + this.pad + this.pad;
        int prefHeight = this.rowHeight * this.rows;
        this.baseOffset = Tools.fontBase + this.pad;
        Dimension boxSize = new Dimension(prefWidth, prefHeight);
        this.setPreferredSize(boxSize);
        this.setMinimumSize(boxSize);
        this.setMaximumSize(boxSize);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        int lineHeight = this.rowHeight;
        int startY = this.baseOffset;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.getFont());
        QBusReadDTO dto = new QBusReadDTO();
        int index = 0;
        while (index < this.rows) {
            String buf = "";
            if (index >= 0 && index < 8) {
                buf = String.format("%2s = %06o", Disasm.getRegName(index), this.cpu.regs[index] & 0xFFFF);
            } else if (index == 8) {
                buf = String.format("PSW: %06o", this.cpu.psw & 0xFFFF);
            } else if (index == 9) {
                StringBuilder sb = new StringBuilder(11);
                short tmp = this.cpu.psw;
                int i = 11;
                while (i > 0) {
                    sb.append((tmp & 1 << i - 1) > 0 ? PSW_BITNAMES.charAt(11 - i) : (char)' ');
                    --i;
                }
                buf = sb.toString();
            } else if (index == 10) {
                this.timer.readWord(65478, dto, false);
                buf = String.format("TMS: %06o", dto.value & 0xFFFF);
            } else if (index == 11) {
                this.timer.readWord(65480, dto, false);
                buf = String.format("TMC: %06o", dto.value & 0xFFFF);
            } else if (index == 12) {
                this.timer.readWord(65482, dto, false);
                buf = String.format("TMF: %06o", dto.value & 0xFFFF);
            } else {
                buf = "";
            }
            g.drawString(buf, this.pad, startY);
            startY += lineHeight;
            ++index;
        }
    }
}

