/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.helpers.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class InputLine
extends JComponent {
    private static final long serialVersionUID = 1L;
    boolean active;
    String idleText = "Input something here";
    String promptText;
    String inputText;
    char[] inputBuffer;
    int inputLength;
    Dimension preferredSize;

    public InputLine(int maxLength, String prompt) {
        this.promptText = prompt == null ? "> " : prompt;
        this.inputText = "";
        this.inputBuffer = new char[maxLength];
        this.preferredSize = new Dimension(Tools.fontWidth * (maxLength + this.promptText.length()), Tools.fontHeight + 4);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    protected void paintComponent(Graphics g1) {
        int charWidth = Tools.fontWidth;
        int charBase = Tools.fontBase;
        Graphics2D g = (Graphics2D)g1.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(Tools.monoFont);
        if (!this.active) {
            g.setColor(Color.DARK_GRAY);
            g.drawString(this.idleText, 0, 2 + charBase);
        } else {
            g.setColor(Color.ORANGE);
            g.drawString(this.promptText, 0, 2 + charBase);
            g.setColor(Color.BLACK);
            g.drawString(this.inputText, this.promptText.length() * charWidth, 2 + charBase);
            g.fillRect((this.promptText.length() + this.inputText.length()) * charWidth, 2, charWidth, charBase);
        }
    }
}

