/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.debugger.ui15.AddressDialog;
import bk2010.gui.debugger.ui15.CPURegistersView;
import bk2010.gui.debugger.ui15.DisasmModel;
import bk2010.gui.debugger.ui15.DisasmPanel;
import bk2010.gui.debugger.ui15.LabelsPanel;
import bk2010.gui.debugger.ui15.MemoryPanel;
import bk2010.gui.debugger.ui15.StackView;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.cpu.K1801VM1;
import bk2010.io.Mouse;
import bk2010.util.ResourceManager;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JFrame;

public class DebuggerFrame
extends JFrame
implements KeyListener,
AddressCallback {
    private static final long serialVersionUID = 1L;
    transient K1801VM1 cpu;
    DisasmPanel disasmPanel;
    LabelsPanel labelsPanel;
    MemoryPanel memoryPanel;
    Box systemPanel;
    AddressDialog addrDialog;
    private static final int DBG_OFF = 0;
    private static final int DBG_TRACE = 1;
    private static final int DBG_LOCK = 2;
    volatile int dbgState = 0;

    public DebuggerFrame(K1801VM1 cpu, CPUTimer timer) {
        super("Debugger");
        this.setIconImage(ResourceManager.getEmulatorIcon());
        this.cpu = cpu;
        this.setDefaultCloseOperation(1);
        this.labelsPanel = new LabelsPanel(this);
        this.labelsPanel.loadLabels("default.map");
        this.add((Component)this.labelsPanel, "West");
        this.disasmPanel = new DisasmPanel(new DisasmModel(cpu.machine));
        this.add((Component)this.disasmPanel, "Center");
        this.memoryPanel = new MemoryPanel(cpu.machine);
        this.add((Component)this.memoryPanel, "South");
        this.systemPanel = Box.createVerticalBox();
        this.systemPanel.add(new CPURegistersView(cpu, timer));
        this.systemPanel.add(new StackView(cpu, cpu.machine));
        this.add((Component)this.systemPanel, "East");
        this.pack();
        this.setFocusable(true);
        this.setAutoRequestFocus(true);
        this.disasmPanel.addKeyListener(this);
        this.disasmPanel.requestFocusInWindow();
    }

    @Override
    public void selectAddress(int address) {
        if (address >= 0 && address < 65536) {
            this.disasmPanel.ensureVisible(address);
        }
    }

    public void resync() {
        this.disasmPanel.purge();
        this.disasmPanel.setPC(this.cpu.regs[7]);
    }

    public boolean invokeDebugger() {
        this.resync();
        this.dbgState = 2;
        this.setVisible(true);
        this.repaint();
        while (this.dbgState == 2) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.isVisible()) continue;
            this.dbgState = 0;
        }
        return this.dbgState == 1;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.dbgState == 2) {
            switch (e.getKeyCode()) {
                case 71: {
                    this.dbgState = 0;
                    break;
                }
                case 32: {
                    this.dbgState = 1;
                    break;
                }
                case 65: {
                    if (this.addrDialog == null) {
                        this.addrDialog = new AddressDialog(this);
                    }
                    this.addrDialog.clearInput();
                    this.addrDialog.setVisible(true);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static void main(String[] args) throws IOException {
        BaseBK001x machine = new BaseBK001x(new Mouse(), false);
        TimeSource stillTime = new TimeSource(){

            @Override
            public long getCycles() {
                return 0L;
            }
        };
        machine.setTimeSource(stillTime, 1000000);
        machine.timer.setTimeSource(stillTime);
        K1801VM1 cpu = new K1801VM1(machine);
        DebuggerFrame fr = new DebuggerFrame(cpu, new CPUTimer());
        fr.setDefaultCloseOperation(3);
        fr.resync();
        fr.setVisible(true);
    }
}

