/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import java.awt.image.IndexColorModel;
import java.util.Arrays;

public final class Palette {
    static final int[] baseColors;
    public static final byte BK_BLACK = 0;
    public static final byte BK_BLUE = 9;
    public static final byte BK_GREEN = 10;
    public static final byte BK_RED = 12;
    public static final byte BK_YELLOW = 14;
    public static final byte BK_MAGENTA = 13;
    public static final byte BK_CYAN = 11;
    public static final byte BK_WHITE = 15;
    public static final byte BK_MIDRED = 16;
    public static final byte BK_DARKRED = 17;
    public static final byte BK_YELLOWGREEN = 18;
    public static final byte BK_LIGHTGREEN = 19;
    public static final byte BK_VIOLET = 20;
    public static final byte BK_DARKVIOLET = 21;
    public static final byte BK_LIGHTGRAY = 7;
    public static final byte BK_DARKGRAY = 8;
    public static final byte BK_AMBER = 22;
    public static final byte BK_BLUISHWHITE = 23;
    public static final byte BK_TERMINALGREEN = 24;
    private static final int MIX_CODES = 22;
    private static final int RENDER_CODES = 25;
    private static IndexColorModel bk2010ColorModel;
    private static IndexColorModel bgr233model;
    private static byte[] bk2010Palette;
    private static byte[] colorMixLUT;
    private static final double gamma = 2.2;
    private static final double recGamma = 0.45454545454545453;
    private static final int[] gammaTable;
    private static final int[] recGammaTable;

    static {
        int[] nArray = new int[25];
        nArray[1] = 192;
        nArray[2] = 49152;
        nArray[3] = 49344;
        nArray[4] = 0xC00000;
        nArray[5] = 0xC000C0;
        nArray[6] = 0xC0C000;
        nArray[7] = 0xC0C0C0;
        nArray[8] = 0x909090;
        nArray[9] = 255;
        nArray[10] = 65280;
        nArray[11] = 65535;
        nArray[12] = 0xFF0000;
        nArray[13] = 0xFF00FF;
        nArray[14] = 0xFFFF00;
        nArray[15] = 0xFFFFFF;
        nArray[16] = 0xC00000;
        nArray[17] = 0x900000;
        nArray[18] = 0xC0FF00;
        nArray[19] = 0x90FF00;
        nArray[20] = 0xC000FF;
        nArray[21] = 0x9000FF;
        nArray[22] = 0xFFB000;
        nArray[23] = 0xDADAFF;
        nArray[24] = 0x20FF20;
        baseColors = nArray;
        gammaTable = new int[256];
        recGammaTable = new int[256];
        Palette.calcGammaTables();
    }

    private static void computeColorMixLUT(boolean skipPredefined) {
        int i = 0;
        while (i < colorMixLUT.length) {
            if (!skipPredefined || colorMixLUT[i] == 0) {
                int x = i & 0xFF;
                int y = i >> 8 & 0xFF;
                if (x == y) {
                    Palette.colorMixLUT[i] = (byte)x;
                } else {
                    int rv = gammaTable[bk2010Palette[x * 3] & 0xFF];
                    int gv = gammaTable[bk2010Palette[x * 3 + 1] & 0xFF];
                    int bv = gammaTable[bk2010Palette[x * 3 + 2] & 0xFF];
                    rv = rv + gammaTable[bk2010Palette[y * 3] & 0xFF] >> 1;
                    gv = gv + gammaTable[bk2010Palette[y * 3 + 1] & 0xFF] >> 1;
                    bv = bv + gammaTable[bk2010Palette[y * 3 + 2] & 0xFF] >> 1;
                    int best = 0;
                    int bestdist = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < 256) {
                        int rt = gammaTable[bk2010Palette[j * 3] & 0xFF] - rv;
                        int gt = gammaTable[bk2010Palette[j * 3 + 1] & 0xFF] - gv;
                        int bt = gammaTable[bk2010Palette[j * 3 + 2] & 0xFF] - bv;
                        int sqdist = rt * rt + gt * gt + bt * bt;
                        if (sqdist < bestdist) {
                            best = j;
                            bestdist = sqdist;
                        }
                        ++j;
                    }
                    Palette.colorMixLUT[i] = (byte)best;
                }
            }
            ++i;
        }
    }

    private static void computeBK2010ColorModel() {
        colorMixLUT = new byte[65536];
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        int count = 0;
        int i = 0;
        while (i < 25) {
            int color = baseColors[i];
            r[i] = (byte)(color >> 16);
            g[i] = (byte)(color >> 8);
            b[i] = (byte)color;
            ++count;
            ++i;
        }
        i = 1;
        while (i < 256) {
            Palette.colorMixLUT[i + i * 256] = (byte)i;
            ++i;
        }
        i = 1;
        while (i < 22) {
            int j = 0;
            while (j < i) {
                int ca = baseColors[i];
                int cb = baseColors[j];
                int ra = ca >> 16 & 0xFF;
                int ga = ca >> 8 & 0xFF;
                int ba = ca & 0xFF;
                int rb = cb >> 16 & 0xFF;
                int gb = cb >> 8 & 0xFF;
                int bb = cb & 0xFF;
                int rm = gammaTable[ra] + gammaTable[rb] >> 1 & 0xFF;
                int gm = gammaTable[ga] + gammaTable[gb] >> 1 & 0xFF;
                int bm = gammaTable[ba] + gammaTable[bb] >> 1 & 0xFF;
                r[count] = (byte)recGammaTable[rm];
                g[count] = (byte)recGammaTable[gm];
                b[count] = (byte)recGammaTable[bm];
                Palette.colorMixLUT[i + j * 256] = (byte)count;
                Palette.colorMixLUT[i * 256 + j] = (byte)count;
                ++count;
                ++j;
            }
            ++i;
        }
        bk2010ColorModel = new IndexColorModel(8, 256, r, g, b);
        bk2010Palette = new byte[768];
        int j = 0;
        while (j < 256) {
            Palette.bk2010Palette[j * 3] = r[j];
            Palette.bk2010Palette[j * 3 + 1] = g[j];
            Palette.bk2010Palette[j * 3 + 2] = b[j];
            ++j;
        }
        Palette.computeColorMixLUT(true);
    }

    public static IndexColorModel getBK2010ColorModel() {
        if (bk2010ColorModel == null) {
            Palette.computeBK2010ColorModel();
        }
        return bk2010ColorModel;
    }

    public static byte[] getBK2010Palette() {
        return Arrays.copyOf(bk2010Palette, 768);
    }

    public static IndexColorModel getBGR233Model() {
        if (bgr233model == null) {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            int i = 0;
            while (i < 256) {
                int tmp = i << 5 & 0xE0;
                tmp |= tmp >> 3;
                tmp |= tmp >> 6;
                r[i] = (byte)tmp;
                tmp = i << 2 & 0xE0;
                tmp |= tmp >> 3;
                tmp |= tmp >> 6;
                g[i] = (byte)tmp;
                tmp = i & 0xC0;
                tmp |= tmp >> 2;
                tmp |= tmp >> 4;
                b[i] = (byte)tmp;
                ++i;
            }
            bgr233model = new IndexColorModel(8, 256, r, g, b);
        }
        return bgr233model;
    }

    public static byte[] getBKColorMixLUT() {
        return colorMixLUT;
    }

    private Palette() {
    }

    private static void calcGammaTables() {
        int i = 0;
        while (i < 256) {
            double d = (double)i / 255.0;
            Palette.gammaTable[i] = (int)(Math.min(Math.pow(d, 2.2), 1.0) * 255.0);
            Palette.recGammaTable[i] = (int)(Math.min(Math.pow(d, 0.45454545454545453), 1.0) * 255.0);
            ++i;
        }
    }
}

