/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.helpers.Tools;
import bk2010.io.KeyMapper;
import bk2010.io.Mouse;
import bk2010.util.BootLog;
import bk2010.util.LogBuffer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public abstract class BK2010Display {
    protected Mouse mouse;
    BufferedImage display;
    protected KeyMapper keyMapper;
    protected int scrWidth;
    protected int scrHeight;
    protected int viewX;
    protected int viewY;
    protected int viewWidth;
    protected int viewHeight;
    protected boolean interpolate;
    protected boolean showBootLog = true;
    protected long bootLogDecayAt;
    protected final Color bootBG = new Color(0x808060);
    protected static Cursor emptyCursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 6), new Point(0, 0), "InvisibleCursor");

    protected void drawBootLog(Graphics2D g, float opacity) {
        LogBuffer history = BootLog.getHistory();
        int lineCount = history.size();
        if (lineCount <= 0) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int color = (int)(255.0f * opacity) << 24;
        g.setColor(new Color(color |= 0xFFFF, true));
        Font font = Tools.monoFont;
        g.setFont(font);
        int fontHeight = font.getSize();
        byte baseOffset = font.getBaselineFor('W');
        lineCount = Math.min(lineCount, this.scrHeight / fontHeight);
        int line = 0;
        while (line < lineCount) {
            String logLine = history.getLine(line);
            if (!logLine.isEmpty()) {
                g.drawString(logLine, 0, baseOffset + (line + 1) * fontHeight);
            }
            ++line;
        }
    }

    protected void paintMe(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        if (this.display == null) {
            g.setColor(this.bootBG);
            g.fillRect(0, 0, this.scrWidth, this.scrHeight);
            this.drawBootLog(g, 1.0f);
            this.bootLogDecayAt = System.currentTimeMillis() + 4000L;
            return;
        }
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.scrWidth, this.scrHeight);
        if (this.interpolate) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g.drawImage(this.display, this.viewX, this.viewY, this.viewWidth, this.viewHeight, null);
        if (this.showBootLog) {
            long bootTTL = this.bootLogDecayAt - System.currentTimeMillis();
            if (bootTTL < 0L) {
                this.showBootLog = false;
            } else {
                this.drawBootLog(g, bootTTL >= 1000L ? 1.0f : (float)bootTTL * 0.001f);
            }
        }
    }

    public void setDisplay(BufferedImage disp) {
        this.display = disp;
    }

    public KeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    public boolean isFullScreen() {
        return false;
    }

    public abstract Point getLocationOnScreen();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract void notifyMouseGrabToggle(boolean var1);

    public abstract void requestFocusInWindow();

    public abstract void requestFocus();

    public abstract void repaint();

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void hideHUD() {
        this.showBootLog = false;
    }
}

